/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.shelled.ui.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class SHDollarRule
implements IRule {
    private IToken defaultToken;
    private IWordDetector detector;
    private IToken successToken;
    private StringBuffer buffer = new StringBuffer();
    private char openBrace;
    private char closeBrace;
    private boolean bracesRequired;

    public SHDollarRule(IWordDetector detector, IToken defaultToken, IToken token, boolean bracesRequired, char openBrace, char closeBrace) {
        this.detector = detector;
        this.successToken = token;
        this.defaultToken = defaultToken;
        this.openBrace = openBrace;
        this.closeBrace = closeBrace;
        this.bracesRequired = bracesRequired;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.detector.isWordStart((char)c)) {
            this.buffer.setLength(0);
            int counter = 0;
            do {
                this.buffer.append((char)c);
            } while ((c = scanner.read()) != -1 && (this.detector.isWordPart((char)c) || c == this.openBrace && ++counter == 1));
            if (c == this.closeBrace) {
                this.buffer.append((char)c);
            } else {
                scanner.unread();
            }
            if (this.buffer.length() > 1) {
                char startChar = this.buffer.charAt(1);
                char endChar = this.buffer.charAt(this.buffer.length() - 1);
                if (startChar == this.openBrace && endChar == this.closeBrace || !this.bracesRequired && Character.isJavaLetterOrDigit(startChar) && Character.isJavaLetterOrDigit(endChar)) {
                    return this.successToken;
                }
            }
            if (this.defaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.defaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.buffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

