/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.shelled.ui.editors;

import com.something.eclipse.script.contentassist.HTMLTextPresenter;
import com.something.eclipse.script.text.IndentType;
import com.something.eclipse.script.text.ScriptAutoIndentStrategy;
import com.something.eclipse.script.text.WhitespaceDetector;
import com.something.eclipse.shelled.ui.editors.ColorManager;
import com.something.eclipse.shelled.ui.editors.SHEditor;
import com.something.eclipse.shelled.ui.editors.SHInformationProvider;
import com.something.eclipse.shelled.ui.text.SHPartitionScanner;
import com.something.eclipse.shelled.ui.text.SHScannerManager;
import com.something.eclipse.shelled.ui.text.hover.SHTextHover;
import java.util.ArrayList;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class SHEditorConfiguration
extends SourceViewerConfiguration {
    private SHScannerManager scannerManager;
    private SHEditor editor;

    public SHEditorConfiguration(SHEditor editor, ColorManager colorManager, int shellType) {
        this.scannerManager = new SHScannerManager(colorManager, shellType);
        this.editor = editor;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new SHTextHover();
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        SHInformationProvider provider = new SHInformationProvider((IEditorPart)this.editor);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setSizeConstraints(42, 15, true, true);
        return presenter;
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer sourceViewer, String contentType) {
        ScriptAutoIndentStrategy strategy = new ScriptAutoIndentStrategy();
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(SHEditorConfiguration.getKeywords((IToken)new Token((Object)IndentType.INCREMENT), new String[]{"do", "case", "{", "then"}, Token.UNDEFINED));
        rules.add(SHEditorConfiguration.getKeywords((IToken)new Token((Object)IndentType.DECREMENT), new String[]{"done", "esac", "}", "fi", "else", "elif"}, Token.UNDEFINED));
        strategy.setRules(rules.toArray(new IRule[0]));
        return strategy;
    }

    private static IRule getKeywords(IToken keywordToken, String[] words, IToken defaultToken) {
        WordRule wordL = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return !Character.isWhitespace(c);
            }

            public boolean isWordPart(char c) {
                return !Character.isWhitespace(c);
            }
        }, defaultToken);
        int i = 0;
        while (i < words.length) {
            wordL.addWord(words[i], keywordToken);
            ++i;
        }
        return wordL;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return SHPartitionScanner.CONTENT_TYPES;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.scannerManager.getScanner("__dftl_partition_content_type"));
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer(this.scannerManager.getScanner("__comment"));
        reconciler.setDamager((IPresentationDamager)dr, "__comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__comment");
        dr = new DefaultDamagerRepairer(this.scannerManager.getScanner("__hashbang"));
        reconciler.setDamager((IPresentationDamager)dr, "__hashbang");
        reconciler.setRepairer((IPresentationRepairer)dr, "__hashbang");
        dr = new DefaultDamagerRepairer(this.scannerManager.getScanner("__single_quote"));
        reconciler.setDamager((IPresentationDamager)dr, "__single_quote");
        reconciler.setRepairer((IPresentationRepairer)dr, "__single_quote");
        dr = new DefaultDamagerRepairer(this.scannerManager.getScanner("__double_quote"));
        reconciler.setDamager((IPresentationDamager)dr, "__double_quote");
        reconciler.setRepairer((IPresentationRepairer)dr, "__double_quote");
        dr = new DefaultDamagerRepairer(this.scannerManager.getScanner("__eval"));
        reconciler.setDamager((IPresentationDamager)dr, "__eval");
        reconciler.setRepairer((IPresentationRepairer)dr, "__eval");
        return reconciler;
    }
}

