/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.util.ITaskThreadPoolCallback;
import net.sourceforge.squirrel_sql.fw.util.TaskExecuter;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TaskThreadPool {
    private static ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$util$TaskThreadPool == null ? (class$net$sourceforge$squirrel_sql$fw$util$TaskThreadPool = TaskThreadPool.class$("net.sourceforge.squirrel_sql.fw.util.TaskThreadPool")) : class$net$sourceforge$squirrel_sql$fw$util$TaskThreadPool);
    private int _iFree;
    private int _threadCount;
    private List _tasks = new ArrayList();
    private MyCallback _callback = new MyCallback();
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$util$TaskThreadPool;

    public TaskThreadPool() {
        this(0);
    }

    public TaskThreadPool(int maxThreads) throws IllegalArgumentException {
        if (maxThreads < 0) {
            throw new IllegalArgumentException("Negative maxThreads passed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTask(Runnable task) throws IllegalArgumentException {
        if (task == null) {
            throw new IllegalArgumentException("Null Runnable passed");
        }
        this._tasks.add(task);
        if (this._iFree == 0) {
            Thread th = new Thread(new TaskExecuter(this._callback));
            th.setPriority(1);
            th.setDaemon(true);
            th.start();
            ++this._threadCount;
            s_log.debug("Creating thread nbr: " + this._threadCount);
        } else {
            MyCallback myCallback = this._callback;
            synchronized (myCallback) {
                s_log.debug("Reusing existing thread");
                this._callback.notify();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class MyCallback
    implements ITaskThreadPoolCallback {
        private MyCallback() {
        }

        public void incrementFreeThreadCount() {
            ++TaskThreadPool.this._iFree;
            s_log.debug("Returning thread. " + TaskThreadPool.this._iFree + " threads available");
        }

        public void decrementFreeThreadCount() {
            --TaskThreadPool.this._iFree;
            s_log.debug("Using a thread. " + TaskThreadPool.this._iFree + " threads available");
        }

        public synchronized Runnable nextTask() {
            if (TaskThreadPool.this._tasks.size() > 0) {
                return (Runnable)TaskThreadPool.this._tasks.remove(0);
            }
            return null;
        }

        public void showMessage(Throwable th) {
            s_log.error("Error", th);
        }
    }
}

