/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class Resources {
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$util$Resources == null ? (class$net$sourceforge$squirrel_sql$fw$util$Resources = Resources.class$("net.sourceforge.squirrel_sql.fw.util.Resources")) : class$net$sourceforge$squirrel_sql$fw$util$Resources);
    private final ResourceBundle _bundle;
    private final String _imagePath;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$util$Resources;

    protected Resources(String rsrcBundleBaseName, ClassLoader cl) {
        if (rsrcBundleBaseName == null || rsrcBundleBaseName.trim().length() == 0) {
            throw new IllegalArgumentException("Null or empty rsrcBundleBaseName passed");
        }
        this._bundle = ResourceBundle.getBundle(rsrcBundleBaseName, Locale.getDefault(), cl);
        this._imagePath = this._bundle.getString("path.images");
    }

    public KeyStroke getKeyStroke(Action action) {
        String fullKey = "menuitem." + action.getClass().getName();
        String accel = this.getResourceString(fullKey, "accelerator");
        if (accel.length() > 0) {
            return KeyStroke.getKeyStroke(accel);
        }
        return null;
    }

    public JMenuItem addToPopupMenu(Action action, JPopupMenu menu) throws MissingResourceException {
        String accel;
        String mn;
        String fullKey = "menuitem." + action.getClass().getName();
        JMenuItem item = menu.add(action);
        if (action.getValue("MnemonicKey") == null && (mn = this.getResourceString(fullKey, "mnemonic")).length() > 0) {
            item.setMnemonic(mn.charAt(0));
        }
        if (action.getValue("AcceleratorKey") == null && (accel = this.getResourceString(fullKey, "accelerator")).length() > 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(accel));
        }
        item.setToolTipText((String)action.getValue("ShortDescription"));
        return item;
    }

    public JCheckBoxMenuItem addToMenuAsCheckBoxMenuItem(Action action, JMenu menu) throws MissingResourceException {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        menu.add(item);
        this.configureMenuItem(action, item);
        return item;
    }

    public JMenuItem addToMenu(Action action, JMenu menu) throws MissingResourceException {
        JMenuItem item = menu.add(action);
        this.configureMenuItem(action, item);
        return item;
    }

    public JMenu createMenu(String menuKey) throws MissingResourceException {
        JMenu menu = new JMenu();
        String fullKey = "menu." + menuKey;
        menu.setText(this.getResourceString(fullKey, "title"));
        String mn = this.getResourceString(fullKey, "mnemonic");
        if (mn.length() >= 1) {
            menu.setMnemonic(mn.charAt(0));
        }
        return menu;
    }

    public void setupAction(Action action, boolean showColoricons) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        String actionClassName = action.getClass().getName();
        String key = "action." + actionClassName;
        action.putValue("Name", this.getResourceString(key, "name"));
        action.putValue("ShortDescription", this.getResourceString(key, "tooltip"));
        ImageIcon icon = null;
        try {
            if (showColoricons) {
                icon = this.getIcon(key, "rolloverimage");
                action.putValue("SmallIcon", icon);
            } else {
                icon = this.getIcon(key, "image");
                action.putValue("SmallIcon", icon);
            }
        }
        catch (MissingResourceException ex) {
            try {
                icon = this.getIcon(key, "image");
                action.putValue("SmallIcon", icon);
            }
            catch (MissingResourceException ignore) {
                // empty catch block
            }
        }
        try {
            icon = this.getIcon(key, "rolloverimage");
            action.putValue("squirrelRolloverIcon", icon);
        }
        catch (MissingResourceException ignore) {
            // empty catch block
        }
        try {
            icon = this.getIcon(key, "disabledimage");
            action.putValue("squirrelDisabledIcon", icon);
        }
        catch (MissingResourceException ignore) {
            // empty catch block
        }
    }

    public ImageIcon getIcon(String keyName) {
        return this.getIcon(keyName, "image");
    }

    public ImageIcon getIcon(Class objClass, String propName) {
        return this.getIcon(objClass.getName(), propName);
    }

    public ImageIcon getIcon(String keyName, String propName) {
        if (keyName == null) {
            throw new IllegalArgumentException("keyName == null");
        }
        if (propName == null) {
            throw new IllegalArgumentException("propName == null");
        }
        ImageIcon icon = null;
        String rsrcName = this.getResourceString(keyName, propName);
        if (rsrcName != null && rsrcName.length() > 0) {
            icon = this.privateGetIcon(rsrcName);
            if (icon == null) {
                s_log.error("can't load image: " + rsrcName);
            }
        } else {
            s_log.debug("No resource found for " + keyName + " : " + propName);
        }
        return icon;
    }

    public String getString(String key) {
        return this._bundle.getString(key);
    }

    public void configureMenuItem(Action action, JMenuItem item) throws MissingResourceException {
        String accel;
        String mn;
        String fullKey = "menuitem." + action.getClass().getName();
        if (action.getValue("MnemonicKey") == null && (mn = this.getResourceString(fullKey, "mnemonic")).length() > 0) {
            item.setMnemonic(mn.charAt(0));
        }
        if (action.getValue("AcceleratorKey") == null && (accel = this.getResourceString(fullKey, "accelerator")).length() > 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(accel));
        }
        item.setToolTipText((String)action.getValue("ShortDescription"));
        item.setIcon(null);
    }

    protected ResourceBundle getBundle() {
        return this._bundle;
    }

    private ImageIcon privateGetIcon(String iconName) {
        URL url;
        if (iconName != null && iconName.length() > 0 && (url = this.getClass().getResource(this.getImagePathName(iconName))) != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    private String getResourceString(String keyName, String propName) throws MissingResourceException {
        return this._bundle.getString(keyName + "." + propName);
    }

    private String getImagePathName(String iconName) {
        return this._imagePath + iconName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface Keys {
        public static final String ACTION = "action";
        public static final String MENU = "menu";
        public static final String MENU_ITEM = "menuitem";
    }

    private static interface MenuItemProperties
    extends MenuProperties {
        public static final String ACCELERATOR = "accelerator";
    }

    private static interface MenuProperties {
        public static final String TITLE = "title";
        public static final String MNEMONIC = "mnemonic";
    }

    private static interface ActionProperties {
        public static final String DISABLED_IMAGE = "disabledimage";
        public static final String IMAGE = "image";
        public static final String NAME = "name";
        public static final String ROLLOVER_IMAGE = "rolloverimage";
        public static final String TOOLTIP = "tooltip";
    }
}

