/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.PropertyChangeReporter;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLConnection {
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$sql$SQLConnection == null ? (class$net$sourceforge$squirrel_sql$fw$sql$SQLConnection = SQLConnection.class$("net.sourceforge.squirrel_sql.fw.sql.SQLConnection")) : class$net$sourceforge$squirrel_sql$fw$sql$SQLConnection);
    private Connection _conn;
    private final SQLDriverPropertyCollection _connProps;
    private SQLDatabaseMetaData _metaData;
    private boolean _autoCommitOnClose = false;
    private Date _timeOpened;
    private Date _timeClosed;
    private transient PropertyChangeReporter _propChgReporter;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$SQLConnection;

    public SQLConnection(Connection conn, SQLDriverPropertyCollection connProps) {
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        this._conn = conn;
        this._connProps = connProps;
        this._timeOpened = Calendar.getInstance().getTime();
    }

    public void close() throws SQLException {
        SQLException savedEx = null;
        if (this._conn != null) {
            s_log.debug("Closing connection");
            try {
                if (!this._conn.getAutoCommit()) {
                    if (this._autoCommitOnClose) {
                        this._conn.commit();
                    } else {
                        this._conn.rollback();
                    }
                }
            }
            catch (SQLException ex) {
                savedEx = ex;
            }
            this._conn.close();
            this._conn = null;
            this._timeClosed = Calendar.getInstance().getTime();
            if (savedEx != null) {
                s_log.debug("Connection close failed", savedEx);
                throw savedEx;
            }
            s_log.debug("Connection closed successfully");
        }
    }

    public void commit() throws SQLException {
        this.validateConnection();
        this._conn.commit();
    }

    public void rollback() throws SQLException {
        this.validateConnection();
        this._conn.rollback();
    }

    public SQLDriverPropertyCollection getConnectionProperties() {
        return this._connProps;
    }

    public boolean getAutoCommit() throws SQLException {
        this.validateConnection();
        return this._conn.getAutoCommit();
    }

    public void setAutoCommit(boolean value) throws SQLException {
        this.validateConnection();
        Connection conn = this.getConnection();
        boolean oldValue = conn.getAutoCommit();
        if (oldValue != value) {
            this._conn.setAutoCommit(value);
            this.getPropertyChangeReporter().firePropertyChange("autocommit", oldValue, value);
        }
    }

    public boolean getCommitOnClose() {
        return this._autoCommitOnClose;
    }

    public int getTransactionIsolation() throws SQLException {
        this.validateConnection();
        return this._conn.getTransactionIsolation();
    }

    public void setTransactionIsolation(int value) throws SQLException {
        this.validateConnection();
        this._conn.setTransactionIsolation(value);
    }

    public void setCommitOnClose(boolean value) {
        this._autoCommitOnClose = value;
    }

    public Statement createStatement() throws SQLException {
        this.validateConnection();
        return this._conn.createStatement();
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.validateConnection();
        return this._conn.prepareStatement(sql);
    }

    public Date getTimeOpened() {
        return this._timeOpened;
    }

    public Date getTimeClosed() {
        return this._timeClosed;
    }

    public synchronized SQLDatabaseMetaData getSQLMetaData() {
        if (this._metaData == null) {
            this._metaData = new SQLDatabaseMetaData(this);
        }
        return this._metaData;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public String getCatalog() throws SQLException {
        this.validateConnection();
        return this.getConnection().getCatalog();
    }

    public void setCatalog(String catalogName) throws SQLException {
        this.validateConnection();
        Connection conn = this.getConnection();
        String oldValue = conn.getCatalog();
        if (!Utilities.areStringsEqual(oldValue, catalogName)) {
            try {
                conn.setCatalog(catalogName);
            }
            catch (SQLException ex) {
                conn.setCatalog(this.quote(catalogName));
            }
            this.getPropertyChangeReporter().firePropertyChange("catalog", oldValue, catalogName);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validateConnection();
        return this._conn.getWarnings();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().removePropertyChangeListener(listener);
    }

    protected void validateConnection() throws SQLException {
        if (this._conn == null) {
            throw new SQLException("No connection");
        }
    }

    private synchronized PropertyChangeReporter getPropertyChangeReporter() {
        if (this._propChgReporter == null) {
            this._propChgReporter = new PropertyChangeReporter(this);
        }
        return this._propChgReporter;
    }

    private String quote(String str) {
        String identifierQuoteString = "";
        try {
            identifierQuoteString = this.getSQLMetaData().getIdentifierQuoteString();
        }
        catch (SQLException ex) {
            s_log.debug("DBMS doesn't supportDatabasemetaData.getIdentifierQuoteString", ex);
        }
        if (identifierQuoteString != null && !identifierQuoteString.equals(" ")) {
            return identifierQuoteString + str + identifierQuoteString;
        }
        return str;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface IPropertyNames {
        public static final String AUTO_COMMIT = "autocommit";
        public static final String CATALOG = "catalog";
    }
}

