/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.NullMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class MetaDataDataSet
implements IDataSet {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$sql$MetaDataDataSet == null ? (class$net$sourceforge$squirrel_sql$fw$sql$MetaDataDataSet = MetaDataDataSet.class$("net.sourceforge.squirrel_sql.fw.sql.MetaDataDataSet")) : class$net$sourceforge$squirrel_sql$fw$sql$MetaDataDataSet);
    private static final Map s_ignoreMethods = new HashMap();
    private static final String[] s_hdgs;
    private DataSetDefinition _dsDef;
    private Iterator _rowsIter;
    private Object[] _row;
    private IMessageHandler _msgHandler;
    private List _data = new ArrayList();
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$MetaDataDataSet;
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;

    public MetaDataDataSet(DatabaseMetaData md) {
        this(md, null);
    }

    public MetaDataDataSet(DatabaseMetaData md, IMessageHandler msgHandler) {
        this._msgHandler = msgHandler != null ? msgHandler : NullMessageHandler.getInstance();
        this._dsDef = new DataSetDefinition(this.createColumnDefinitions());
        this.load(md);
    }

    public final int getColumnCount() {
        return s_hdgs.length;
    }

    public DataSetDefinition getDataSetDefinition() {
        return this._dsDef;
    }

    public synchronized boolean next(IMessageHandler msgHandler) {
        this._row = this._rowsIter.hasNext() ? (Object[])this._rowsIter.next() : null;
        return this._row != null;
    }

    public synchronized Object get(int columnIndex) {
        return this._row[columnIndex];
    }

    private ColumnDisplayDefinition[] createColumnDefinitions() {
        int columnCount = this.getColumnCount();
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnDefs[i] = new ColumnDisplayDefinition(200, s_hdgs[i]);
        }
        return columnDefs;
    }

    private void load(DatabaseMetaData md) {
        Method[] methods = (class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = MetaDataDataSet.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData).getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE || s_ignoreMethods.containsKey(method.getName())) continue;
            this._data.add(this.generateLine(md, method));
        }
        this._rowsIter = this._data.iterator();
    }

    private Object[] generateLine(DatabaseMetaData md, Method getter) {
        Object[] line = new Object[2];
        line[0] = getter.getName();
        if (line[0].equals("getDefaultTransactionIsolation")) {
            try {
                line[1] = IStrings.UNSUPPORTED;
                int isol = md.getDefaultTransactionIsolation();
                switch (isol) {
                    case 0: {
                        line[1] = "TRANSACTION_NONE";
                        break;
                    }
                    case 2: {
                        line[1] = "TRANSACTION_READ_COMMITTED";
                        break;
                    }
                    case 1: {
                        line[1] = "TRANSACTION_READ_UNCOMMITTED";
                        break;
                    }
                    case 4: {
                        line[1] = "TRANSACTION_REPEATABLE_READ";
                        break;
                    }
                    case 8: {
                        line[1] = "TRANSACTION_SERIALIZABLE";
                        break;
                    }
                    default: {
                        line[1] = "" + isol + "?";
                        break;
                    }
                }
            }
            catch (SQLException ex) {
                this._msgHandler.showMessage(ex);
            }
        } else {
            Object obj;
            line[1] = obj = this.executeGetter(md, getter);
        }
        return line;
    }

    protected Object executeGetter(Object bean, Method getter) {
        try {
            return getter.invoke(bean, null);
        }
        catch (Throwable th) {
            return IStrings.UNSUPPORTED;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static {
        s_ignoreMethods.put("getCatalogs", null);
        s_ignoreMethods.put("getConnection", null);
        s_ignoreMethods.put("getSchemas", null);
        s_ignoreMethods.put("getTableTypes", null);
        s_ignoreMethods.put("getTypeInfo", null);
        s_ignoreMethods.put("fail", null);
        s_ignoreMethods.put("hashCode", null);
        s_ignoreMethods.put("toString", null);
        s_ignoreMethods.put("getNumericFunctions", null);
        s_ignoreMethods.put("getStringFunctions", null);
        s_ignoreMethods.put("getSystemFunctions", null);
        s_ignoreMethods.put("getTimeDateFunctions", null);
        s_ignoreMethods.put("getSQLKeywords", null);
        s_hdgs = new String[]{IStrings.NAME_COLUMN, IStrings.VALUE_COLUMN};
    }

    private static interface IStrings {
        public static final String UNSUPPORTED = MetaDataDataSet.access$000().getString("MetaDataDataSet.unsupported");
        public static final String NAME_COLUMN = MetaDataDataSet.access$000().getString("MetaDataDataSet.propname");
        public static final String VALUE_COLUMN = MetaDataDataSet.access$000().getString("MetaDataDataSet.value");
    }
}

