/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.NullMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;

public class DataCache {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$sql$DataCache == null ? (class$net$sourceforge$squirrel_sql$fw$sql$DataCache = DataCache.class$("net.sourceforge.squirrel_sql.fw.sql.DataCache")) : class$net$sourceforge$squirrel_sql$fw$sql$DataCache);
    private static final Class SQL_ALIAS_IMPL = class$net$sourceforge$squirrel_sql$fw$sql$SQLAlias == null ? (class$net$sourceforge$squirrel_sql$fw$sql$SQLAlias = DataCache.class$("net.sourceforge.squirrel_sql.fw.sql.SQLAlias")) : class$net$sourceforge$squirrel_sql$fw$sql$SQLAlias;
    private static final Class SQL_DRIVER_IMPL = class$net$sourceforge$squirrel_sql$fw$sql$SQLDriver == null ? (class$net$sourceforge$squirrel_sql$fw$sql$SQLDriver = DataCache.class$("net.sourceforge.squirrel_sql.fw.sql.SQLDriver")) : class$net$sourceforge$squirrel_sql$fw$sql$SQLDriver;
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$sql$DataCache == null ? (class$net$sourceforge$squirrel_sql$fw$sql$DataCache = DataCache.class$("net.sourceforge.squirrel_sql.fw.sql.DataCache")) : class$net$sourceforge$squirrel_sql$fw$sql$DataCache);
    private final SQLDriverManager _driverMgr;
    private final XMLObjectCache _cache = new XMLObjectCache();
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$DataCache;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$SQLAlias;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$sql$SQLDriver;

    public DataCache(SQLDriverManager driverMgr, File driversFile, File aliasesFile, URL dftDriversURL, IMessageHandler msgHandler) {
        if (driverMgr == null) {
            throw new IllegalArgumentException("SQLDriverManager == null");
        }
        if (driversFile == null) {
            throw new IllegalArgumentException("driversFile == null");
        }
        if (aliasesFile == null) {
            throw new IllegalArgumentException("aliasesFile == null");
        }
        if (dftDriversURL == null) {
            throw new IllegalArgumentException("dftDriversURL == null");
        }
        this._driverMgr = driverMgr;
        IMessageHandler myMsgHandler = msgHandler;
        if (myMsgHandler == null) {
            myMsgHandler = NullMessageHandler.getInstance();
        }
        this.loadDrivers(driversFile, dftDriversURL, myMsgHandler);
        this.loadAliases(aliasesFile, myMsgHandler);
    }

    public void saveDrivers(File file) throws IOException, XMLException {
        if (file == null) {
            throw new IllegalArgumentException("File == null");
        }
        this._cache.saveAllForClass(file.getPath(), SQL_DRIVER_IMPL);
    }

    public void saveAliases(File file) throws IOException, XMLException {
        if (file == null) {
            throw new IllegalArgumentException("File == null");
        }
        this._cache.saveAllForClass(file.getPath(), SQL_ALIAS_IMPL);
    }

    public ISQLDriver getDriver(IIdentifier id) {
        if (id == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        return (ISQLDriver)this._cache.get(SQL_DRIVER_IMPL, id);
    }

    public void addDriver(ISQLDriver sqlDriver) throws ClassNotFoundException, IllegalAccessException, InstantiationException, DuplicateObjectException, MalformedURLException {
        if (sqlDriver == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        this._driverMgr.registerSQLDriver(sqlDriver);
        this._cache.add(sqlDriver);
    }

    public void removeDriver(ISQLDriver sqlDriver) {
        this._cache.remove(SQL_DRIVER_IMPL, sqlDriver.getIdentifier());
        this._driverMgr.unregisterSQLDriver(sqlDriver);
    }

    public Iterator drivers() {
        return this._cache.getAllForClass(SQL_DRIVER_IMPL);
    }

    public void addDriversListener(IObjectCacheChangeListener lis) {
        this._cache.addChangesListener(lis, SQL_DRIVER_IMPL);
    }

    public void removeDriversListener(IObjectCacheChangeListener lis) {
        this._cache.removeChangesListener(lis, SQL_DRIVER_IMPL);
    }

    public ISQLAlias getAlias(IIdentifier id) {
        return (ISQLAlias)this._cache.get(SQL_ALIAS_IMPL, id);
    }

    public Iterator aliases() {
        return this._cache.getAllForClass(SQL_ALIAS_IMPL);
    }

    public void addAlias(ISQLAlias alias) throws DuplicateObjectException {
        this._cache.add(alias);
    }

    public void removeAlias(ISQLAlias alias) {
        this._cache.remove(SQL_ALIAS_IMPL, alias.getIdentifier());
    }

    public Iterator getAliasesForDriver(ISQLDriver driver) {
        ArrayList<ISQLAlias> data = new ArrayList<ISQLAlias>();
        Iterator it = this.aliases();
        while (it.hasNext()) {
            ISQLAlias alias = (ISQLAlias)it.next();
            if (!driver.equals(this.getDriver(alias.getDriverIdentifier()))) continue;
            data.add(alias);
        }
        return data.iterator();
    }

    public void addAliasesListener(IObjectCacheChangeListener lis) {
        this._cache.addChangesListener(lis, SQL_ALIAS_IMPL);
    }

    public void removeAliasesListener(IObjectCacheChangeListener lis) {
        this._cache.removeChangesListener(lis, SQL_ALIAS_IMPL);
    }

    private void loadDrivers(File driversFile, URL dftDriversURL, IMessageHandler msgHandler) {
        block10: {
            if (driversFile == null) {
                throw new IllegalArgumentException("driversFile == null");
            }
            if (dftDriversURL == null) {
                throw new IllegalArgumentException("dftDriversURL == null");
            }
            if (msgHandler == null) {
                throw new IllegalArgumentException("msgHandler == null");
            }
            try {
                try {
                    this._cache.load(driversFile.getPath());
                    if (!this.drivers().hasNext()) {
                        this.loadDefaultDrivers(dftDriversURL);
                        break block10;
                    }
                    this.fixupDrivers();
                }
                catch (FileNotFoundException ex) {
                    this.loadDefaultDrivers(dftDriversURL);
                }
                catch (Exception ex) {
                    String msg = s_stringMgr.getString("DataCache.error.loadingdrivers", driversFile.getPath());
                    s_log.error(msg, ex);
                    msgHandler.showErrorMessage(msg);
                    msgHandler.showErrorMessage(ex);
                    this.loadDefaultDrivers(dftDriversURL);
                }
            }
            catch (XMLException ex) {
                s_log.error("Error loading drivers", ex);
            }
            catch (IOException ex) {
                s_log.error("Error loading drivers", ex);
            }
        }
        this.registerDrivers(msgHandler);
    }

    public ISQLAlias createAlias(IIdentifier id) {
        return new SQLAlias(id);
    }

    public ISQLDriver createDriver(IIdentifier id) {
        return new SQLDriver(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDefaultDrivers(URL url) throws IOException, XMLException {
        InputStreamReader isr = new InputStreamReader(url.openStream());
        try {
            this._cache.load(isr, null, true);
        }
        catch (DuplicateObjectException ex) {
            s_log.error("Received an unexpected DuplicateObjectException", ex);
        }
        finally {
            isr.close();
        }
    }

    private void registerDrivers(IMessageHandler msgHandler) {
        SQLDriverManager driverMgr = this._driverMgr;
        Iterator it = this.drivers();
        while (it.hasNext()) {
            ISQLDriver sqlDriver = (ISQLDriver)it.next();
            try {
                driverMgr.registerSQLDriver(sqlDriver);
            }
            catch (ClassNotFoundException ignore) {
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("DataCache.error.registerdriver", sqlDriver.getName());
                s_log.error(msg, th);
                msgHandler.showErrorMessage(msg);
                msgHandler.showErrorMessage(th);
            }
        }
    }

    private void loadAliases(File aliasesFile, IMessageHandler msgHandler) {
        try {
            this._cache.load(aliasesFile.getPath());
        }
        catch (FileNotFoundException ignore) {
        }
        catch (Exception ex) {
            String msg = s_stringMgr.getString("DataCache.error.loadingaliases", aliasesFile.getPath());
            s_log.error(msg, ex);
            msgHandler.showErrorMessage(msg);
            msgHandler.showErrorMessage(ex);
        }
    }

    private void fixupDrivers() {
        Iterator it = this.drivers();
        while (it.hasNext()) {
            String fileName;
            ISQLDriver driver = (ISQLDriver)it.next();
            String[] fileNames = driver.getJarFileNames();
            if (fileNames != null && fileNames.length != 0 || (fileName = driver.getJarFileName()) == null || fileName.length() <= 0) continue;
            driver.setJarFileNames(new String[]{fileName});
            try {
                driver.setJarFileName(null);
            }
            catch (ValidationException ignore) {}
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

