/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.sql;

import java.sql.DriverPropertyInfo;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverProperty;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class DriverPropertiesTableModel
extends AbstractTableModel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$gui$sql$DriverPropertiesTableModel == null ? (class$net$sourceforge$squirrel_sql$fw$gui$sql$DriverPropertiesTableModel = DriverPropertiesTableModel.class$("net.sourceforge.squirrel_sql.fw.gui.sql.DriverPropertiesTableModel")) : class$net$sourceforge$squirrel_sql$fw$gui$sql$DriverPropertiesTableModel);
    private final int COLUMN_COUNT = 5;
    private static final ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$gui$sql$DriverPropertiesTableModel == null ? (class$net$sourceforge$squirrel_sql$fw$gui$sql$DriverPropertiesTableModel = DriverPropertiesTableModel.class$("net.sourceforge.squirrel_sql.fw.gui.sql.DriverPropertiesTableModel")) : class$net$sourceforge$squirrel_sql$fw$gui$sql$DriverPropertiesTableModel);
    private SQLDriverPropertyCollection _props = new SQLDriverPropertyCollection();
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$gui$sql$DriverPropertiesTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    DriverPropertiesTableModel(SQLDriverPropertyCollection props) {
        if (props == null) {
            throw new IllegalArgumentException("SQLDriverPropertyCollection[] == null");
        }
        this.load(props);
    }

    public Object getValueAt(int row, int col) {
        SQLDriverProperty sdp = this._props.getDriverProperty(row);
        switch (col) {
            case 0: {
                return sdp.getName();
            }
            case 1: {
                return new Boolean(sdp.isSpecified());
            }
            case 2: {
                return sdp.getValue();
            }
            case 3: {
                DriverPropertyInfo dpi = sdp.getDriverPropertyInfo();
                if (dpi != null) {
                    return new Boolean(dpi.required);
                }
                return Boolean.FALSE;
            }
            case 4: {
                DriverPropertyInfo dpi = sdp.getDriverPropertyInfo();
                if (dpi != null) {
                    return dpi.description;
                }
                return s_stringMgr.getString("DriverPropertiesTableModel.unknown");
            }
        }
        s_log.error("Invalid column index: " + col);
        return "???????";
    }

    public int getRowCount() {
        return this._props.size();
    }

    public int getColumnCount() {
        return 5;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return class$java$lang$String == null ? (class$java$lang$String = DriverPropertiesTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 1: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DriverPropertiesTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            case 2: {
                return class$java$lang$String == null ? (class$java$lang$String = DriverPropertiesTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 3: {
                return class$java$lang$Object == null ? (class$java$lang$Object = DriverPropertiesTableModel.class$("java.lang.Object")) : class$java$lang$Object;
            }
            case 4: {
                return class$java$lang$String == null ? (class$java$lang$String = DriverPropertiesTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        }
        s_log.error("Invalid column index: " + col);
        return class$java$lang$Object == null ? (class$java$lang$Object = DriverPropertiesTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1 || col == 2;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 2) {
            SQLDriverProperty sdp = this._props.getDriverProperty(row);
            sdp.setValue(value.toString());
        } else if (col == 1) {
            SQLDriverProperty sdp = this._props.getDriverProperty(row);
            Boolean bool = Boolean.valueOf(value.toString());
            sdp.setIsSpecified(bool);
        } else {
            throw new IllegalStateException("Can only edit value/specify column. Trying to edit " + col);
        }
    }

    SQLDriverPropertyCollection getSQLDriverProperties() {
        return this._props;
    }

    private final void load(SQLDriverPropertyCollection props) {
        int origSize = this.getRowCount();
        if (origSize > 0) {
            this.fireTableRowsDeleted(0, origSize - 1);
        }
        this._props = props;
        int newSize = this.getRowCount();
        if (newSize > 0) {
            this.fireTableRowsInserted(0, newSize - 1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface IColumnIndexes {
        public static final int IDX_NAME = 0;
        public static final int IDX_SPECIFY = 1;
        public static final int IDX_VALUE = 2;
        public static final int IDX_REQUIRED = 3;
        public static final int IDX_DESCRIPTION = 4;
    }
}

