/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.gui.action.MakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyHtmlCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableSelectAllCellsCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.UndoMakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TablePopupMenu
extends BasePopupMenu {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$gui$TablePopupMenu == null ? (class$net$sourceforge$squirrel_sql$fw$gui$TablePopupMenu = TablePopupMenu.class$("net.sourceforge.squirrel_sql.fw.gui.TablePopupMenu")) : class$net$sourceforge$squirrel_sql$fw$gui$TablePopupMenu);
    private final JMenuItem[] _menuItems = new JMenuItem[3];
    private JTable _table;
    private CutAction _cut = new CutAction();
    private CopyAction _copy = new CopyAction();
    private CopyHtmlAction _copyHtml = new CopyHtmlAction();
    private PasteAction _paste = new PasteAction();
    private MakeEditableAction _makeEditable = new MakeEditableAction();
    private UndoMakeEditableAction _undoMakeEditable = new UndoMakeEditableAction();
    private DeleteRowsAction _deleteRows = new DeleteRowsAction();
    protected InsertRowAction _insertRow = new InsertRowAction();
    private SelectAllAction _select = new SelectAllAction();
    private PrintAction _print = new PrintAction();
    private IDataSetUpdateableModel _updateableModel = null;
    private DataSetViewerTablePanel _viewer = null;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$gui$TablePopupMenu;

    public TablePopupMenu(boolean allowEditing, IDataSetUpdateableModel updateableModel, DataSetViewerTablePanel viewer) {
        this._updateableModel = updateableModel;
        this._viewer = viewer;
        this._menuItems[0] = this.add(this._copy);
        this._menuItems[1] = this.add(this._copyHtml);
        if (allowEditing) {
            this.addSeparator();
            this.add(this._makeEditable);
        }
        if (updateableModel != null && updateableModel.editModeIsForced()) {
            this.add(this._undoMakeEditable);
        }
        this.addSeparator();
        this._menuItems[2] = this.add(this._select);
        if (this._updateableModel != null && !allowEditing) {
            this.addSeparator();
            this.add(this._insertRow);
            this.add(this._deleteRows);
        }
        this.addSeparator();
        this.add(this._print);
    }

    public TablePopupMenu(IDataSetUpdateableModel updateableModel, DataSetViewerTablePanel viewer, JTable table) {
        this._updateableModel = updateableModel;
        this._viewer = viewer;
        this._table = table;
        this.add(this._select);
        this.addSeparator();
        this.add(this._insertRow);
        this.add(this._deleteRows);
        this.addSeparator();
        this.add(this._print);
    }

    public void setTable(JTable value) {
        this._table = value;
    }

    public void show(Component invoker, int x, int y) {
        this.updateActions();
        super.show(invoker, x, y);
    }

    public void show(MouseEvent evt) {
        this.updateActions();
        super.show(evt);
    }

    protected void updateActions() {
        boolean isEditable = false;
        this._cut.setEnabled(false);
        this._paste.setEnabled(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PrintAction
    extends BaseAction {
        PrintAction() {
            super(s_stringMgr.getString("TablePopupMenu.print"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                try {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable(TablePopupMenu.this._viewer);
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class SelectAllAction
    extends BaseAction {
        SelectAllAction() {
            super(s_stringMgr.getString("TablePopupMenu.selectall"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableSelectAllCellsCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class InsertRowAction
    extends BaseAction {
        InsertRowAction() {
            super(s_stringMgr.getString("TablePopupMenu.insertrow"));
        }

        public void actionPerformed(ActionEvent evt) {
            TablePopupMenu.this._viewer.insertRow();
        }
    }

    private class DeleteRowsAction
    extends BaseAction {
        DeleteRowsAction() {
            super(s_stringMgr.getString("TablePopupMenu.deleterows"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                int[] selectedRows = TablePopupMenu.this._table.getSelectedRows();
                TablePopupMenu.this._viewer.deleteRows(selectedRows);
            }
        }
    }

    private class UndoMakeEditableAction
    extends BaseAction {
        UndoMakeEditableAction() {
            super(s_stringMgr.getString("TablePopupMenu.undomakeeditable"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._updateableModel != null) {
                new UndoMakeEditableCommand(TablePopupMenu.this._updateableModel).execute();
            }
        }
    }

    private class MakeEditableAction
    extends BaseAction {
        MakeEditableAction() {
            super(s_stringMgr.getString("TablePopupMenu.makeeditable"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._updateableModel != null) {
                new MakeEditableCommand(TablePopupMenu.this._updateableModel).execute();
            }
        }
    }

    private class PasteAction
    extends BaseAction {
        PasteAction() {
            super(s_stringMgr.getString("TablePopupMenu.paste"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                // empty if block
            }
        }
    }

    private class CopyHtmlAction
    extends BaseAction {
        CopyHtmlAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyashtml"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyHtmlCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopyAction
    extends BaseAction {
        CopyAction() {
            super(s_stringMgr.getString("TablePopupMenu.copy"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CutAction
    extends BaseAction {
        CutAction() {
            super(s_stringMgr.getString("TablePopupMenu.cut"));
        }

        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                // empty if block
            }
        }
    }

    public static interface IOptionTypes {
        public static final int COPY = 0;
        public static final int COPY_HTML = 1;
        public static final int SELECT_ALL = 2;
        public static final int LAST_ENTRY = 2;
    }
}

