/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class ScrollableDesktopPane
extends JDesktopPane {
    private MyComponentListener _listener = new MyComponentListener();

    protected void paintComponent(Graphics g) {
        this.setPreferredSize(this.getRequiredSize());
        super.paintComponent(g);
    }

    public void remove(Component comp) {
        if (comp != null) {
            comp.removeComponentListener(this._listener);
        }
        super.remove(comp);
        this.revalidate();
        this.repaint();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp != null) {
            comp.addComponentListener(this._listener);
            this.revalidate();
        }
        super.addImpl(comp, constraints, index);
    }

    public Dimension getRequiredSize() {
        JInternalFrame[] frames = this.getAllFrames();
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < frames.length; ++i) {
            int y;
            if (!frames[i].isVisible()) continue;
            JInternalFrame frame = frames[i];
            int x = frame.getX() + frame.getWidth();
            if (x > maxX) {
                maxX = x;
            }
            if ((y = frame.getY() + frame.getHeight()) <= maxY) continue;
            maxY = y;
        }
        return new Dimension(maxX, maxY);
    }

    private final class MyComponentListener
    implements ComponentListener {
        private MyComponentListener() {
        }

        public void componentHidden(ComponentEvent evt) {
            ScrollableDesktopPane.this.revalidate();
        }

        public void componentMoved(ComponentEvent evt) {
            ScrollableDesktopPane.this.revalidate();
        }

        public void componentResized(ComponentEvent evt) {
            ScrollableDesktopPane.this.revalidate();
        }

        public void componentShown(ComponentEvent evt) {
            ScrollableDesktopPane.this.revalidate();
        }
    }
}

