/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JComboBox;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;

public class SQLCatalogsComboBox
extends JComboBox {
    public void setConnection(SQLConnection conn) throws SQLException {
        String[] catalogs;
        if (conn == null) {
            throw new IllegalArgumentException("SQLConnection == null");
        }
        super.removeAllItems();
        SQLDatabaseMetaData md = conn.getSQLMetaData();
        if (md.supportsCatalogs() && (catalogs = md.getCatalogs()) != null) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (int i = 0; i < catalogs.length; ++i) {
                map.put(catalogs[i], catalogs[i]);
            }
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                this.addItem(it.next());
            }
            String selCatalog = conn.getCatalog();
            if (selCatalog != null) {
                this.setSelectedCatalog(selCatalog);
            }
        }
        this.setMaximumSize(this.getPreferredSize());
    }

    public String getSelectedCatalog() {
        return (String)this.getSelectedItem();
    }

    public void setSelectedCatalog(String selectedCatalog) {
        if (selectedCatalog != null) {
            this.getModel().setSelectedItem(selectedCatalog);
        }
    }
}

