/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class BeanPropertyTableModel
extends DefaultTableModel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(class$net$sourceforge$squirrel_sql$fw$gui$BeanPropertyTableModel == null ? (class$net$sourceforge$squirrel_sql$fw$gui$BeanPropertyTableModel = BeanPropertyTableModel.class$("net.sourceforge.squirrel_sql.fw.gui.BeanPropertyTableModel")) : class$net$sourceforge$squirrel_sql$fw$gui$BeanPropertyTableModel);
    private Object _bean;
    private String _nameColumnName = s_stringMgr.getString("BeanPropertyTableModel.namecolumn");
    private String _valueColumnName = s_stringMgr.getString("BeanPropertyTableModel.valuecolumn");
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$gui$BeanPropertyTableModel;

    public void setBean(Object bean) throws BaseException {
        this._bean = bean;
        this.refresh();
    }

    public void refresh() throws BaseException {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(this._nameColumnName);
        columnNames.add(this._valueColumnName);
        Vector columnData = new Vector();
        if (this._bean != null) {
            try {
                BeanInfo info = Introspector.getBeanInfo(this._bean.getClass(), 1);
                this.processBeanInfo(info, columnData);
            }
            catch (Exception ex) {
                throw new BaseException(ex);
            }
        }
        Collections.sort(columnData, new DataSorter());
        this.setDataVector(columnData, columnNames);
    }

    private void processBeanInfo(BeanInfo info, Vector columnData) throws InvocationTargetException, IllegalAccessException {
        BeanInfo[] extra = info.getAdditionalBeanInfo();
        if (extra != null) {
            for (int i = 0; i < extra.length; ++i) {
                this.processBeanInfo(extra[i], columnData);
            }
        }
        PropertyDescriptor[] propDesc = info.getPropertyDescriptors();
        for (int i = 0; i < propDesc.length; ++i) {
            Vector line;
            String propName = propDesc[i].getName();
            Method getter = propDesc[i].getReadMethod();
            if (propName == null || getter == null || (line = this.generateLine(propName, this._bean, getter)) == null) continue;
            columnData.add(line);
        }
    }

    protected Vector generateLine(String propName, Object bean, Method getter) throws InvocationTargetException, IllegalAccessException {
        Vector<Object> line = new Vector<Object>();
        line.add(propName);
        line.add(this.executeGetter(bean, getter));
        return line;
    }

    protected Object executeGetter(Object bean, Method getter) throws InvocationTargetException, IllegalAccessException {
        return getter.invoke(bean, null);
    }

    public void setNameColumnName(String value) {
        this._nameColumnName = value;
    }

    public void setValueColumnName(String value) {
        this._valueColumnName = value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class DataSorter
    implements Comparator {
        private DataSorter() {
        }

        public int compare(Object obj1, Object obj2) {
            String lhs = (String)((Vector)obj1).get(0);
            String rhs = (String)((Vector)obj2).get(0);
            return lhs.compareToIgnoreCase(rhs);
        }
    }
}

