/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Color;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellEditorUsingRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBigDecimal;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBinary;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBlob;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBoolean;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeByte;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeClob;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDate;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDouble;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeFloat;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeInteger;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeLong;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeOther;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeShort;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeString;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTime;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTimestamp;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeUnknown;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CellComponentFactory {
    static HashMap _colDataTypeObjects = new HashMap();
    static HashMap _registeredDataTypes = new HashMap();
    static JTable _table = null;
    private static ILogger s_log = LoggerController.createLogger(class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$CellComponentFactory == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$CellComponentFactory = CellComponentFactory.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$CellComponentFactory);
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$CellComponentFactory;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeBlob;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeClob;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeString;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeOther;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeUnknown;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeDate;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeTime;
    static /* synthetic */ Class class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeTimestamp;

    public static String getClassName(ColumnDisplayDefinition colDef) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.getClassName();
        }
        return "java.lang.Object";
    }

    public static boolean areEqual(ColumnDisplayDefinition colDef, Object newValue, Object oldValue) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.areEqual(newValue, oldValue);
        }
        return false;
    }

    public static String renderObject(Object value, ColumnDisplayDefinition colDef) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.renderObject(value);
        }
        if (null == value) {
            return "<null>";
        }
        return value.toString();
    }

    public static TableCellRenderer getTableCellRenderer(ColumnDisplayDefinition colDef) {
        return new CellRenderer(CellComponentFactory.getDataTypeObject(null, colDef));
    }

    public static boolean isEditableInCell(ColumnDisplayDefinition colDef, Object originalValue) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.isEditableInCell(originalValue);
        }
        return false;
    }

    public static boolean needToReRead(ColumnDisplayDefinition colDef, Object originalValue) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.needToReRead(originalValue);
        }
        return false;
    }

    public static DefaultCellEditor getInCellEditor(JTable table, ColumnDisplayDefinition colDef) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(table, colDef);
        JTextField textField = dataTypeObject != null ? dataTypeObject.getJTextField() : new RestorableJTextField();
        textField.setBackground(Color.yellow);
        CellEditorUsingRenderer ed = new CellEditorUsingRenderer(textField, dataTypeObject);
        ed.setClickCountToStart(1);
        return ed;
    }

    public static Object validateAndConvert(ColumnDisplayDefinition colDef, Object originalValue, String inputValue, StringBuffer messageBuffer) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.validateAndConvert(inputValue, originalValue, messageBuffer);
        }
        if (inputValue.equals("<null>")) {
            return null;
        }
        return inputValue;
    }

    public static boolean useBinaryEditingPanel(ColumnDisplayDefinition colDef) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.useBinaryEditingPanel();
        }
        return false;
    }

    public static boolean isEditableInPopup(ColumnDisplayDefinition colDef, Object originalValue) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.isEditableInPopup(originalValue);
        }
        return false;
    }

    public static JTextArea getJTextArea(ColumnDisplayDefinition colDef, Object value) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.getJTextArea(value);
        }
        RestorableJTextArea textArea = new RestorableJTextArea();
        textArea.setText(value.toString());
        return textArea;
    }

    public static Object validateAndConvertInPopup(ColumnDisplayDefinition colDef, Object originalValue, String inputValue, StringBuffer messageBuffer) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.validateAndConvertInPopup(inputValue, originalValue, messageBuffer);
        }
        if (inputValue.equals("<null>")) {
            return null;
        }
        return inputValue;
    }

    public static Object readResultSet(ColumnDisplayDefinition colDef, ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.readResultSet(rs, index, limitDataRead);
        }
        return rs.getObject(index);
    }

    public static String getWhereClauseValue(ColumnDisplayDefinition colDef, Object value) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.getWhereClauseValue(value);
        }
        return null;
    }

    public static void setPreparedStatementValue(ColumnDisplayDefinition colDef, PreparedStatement pstmt, Object value, int position) throws SQLException {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            dataTypeObject.setPreparedStatementValue(pstmt, value, position);
        }
    }

    public static Object getDefaultValue(ColumnDisplayDefinition colDef, String dbDefaultValue) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject != null) {
            return dataTypeObject.getDefaultValue(dbDefaultValue);
        }
        return null;
    }

    public static boolean canDoFileIO(ColumnDisplayDefinition colDef) {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject == null) {
            return false;
        }
        return dataTypeObject.canDoFileIO();
    }

    public static String importObject(ColumnDisplayDefinition colDef, FileInputStream inStream) throws IOException {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject == null) {
            throw new IOException("No internal Data Type class for this column's SQL type");
        }
        return dataTypeObject.importObject(inStream);
    }

    public static void exportObject(ColumnDisplayDefinition colDef, FileOutputStream outStream, String text) throws IOException {
        IDataTypeComponent dataTypeObject = CellComponentFactory.getDataTypeObject(null, colDef);
        if (dataTypeObject == null) {
            throw new IOException("No internal Data Type class for this column's SQL type");
        }
        dataTypeObject.exportObject(outStream, text);
    }

    public static void registerDataType(String dataTypeObjectName, int sqlType, String sqlTypeName) throws ClassNotFoundException {
        String typeName = Integer.toString(sqlType) + ":" + sqlTypeName;
        try {
            Class<?> handlerClass = Class.forName(dataTypeObjectName);
            Class[] constClasses = new Class[]{new JTable().getClass(), new ColumnDisplayDefinition(0, "").getClass()};
            Constructor<?> handlerConst = handlerClass.getConstructor(constClasses);
            _registeredDataTypes.put(typeName, dataTypeObjectName);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Could not locate class " + dataTypeObjectName);
        }
    }

    public static OkJPanel[] getControlPanels() {
        ArrayList<OkJPanel> panelList = new ArrayList<OkJPanel>();
        String[] initialClassNameList = new String[]{(class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeBlob == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeBlob = CellComponentFactory.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBlob")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeBlob).getName(), (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeClob == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeClob = CellComponentFactory.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeClob")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeClob).getName(), (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeString == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeString = CellComponentFactory.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeString")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeString).getName(), (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeOther == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeOther = CellComponentFactory.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeOther")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeOther).getName(), (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeUnknown == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeUnknown = CellComponentFactory.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeUnknown")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeUnknown).getName(), (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeDate == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeDate = CellComponentFactory.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeDate")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeDate).getName(), (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeTime == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeTime = CellComponentFactory.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTime")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeTime).getName(), (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeTimestamp == null ? (class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeTimestamp = CellComponentFactory.class$("net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTimestamp")) : class$net$sourceforge$squirrel_sql$fw$datasetviewer$cellcomponent$DataTypeTimestamp).getName()};
        ArrayList<String> classNameList = new ArrayList<String>(Arrays.asList(initialClassNameList));
        Iterator classNames = _registeredDataTypes.keySet().iterator();
        while (classNames.hasNext()) {
            classNameList.add((String)classNames.next());
        }
        for (int i = 0; i < classNameList.size(); ++i) {
            String className = classNameList.get(i);
            Class[] parameterTypes = new Class[]{};
            try {
                Method panelMethod = Class.forName(className).getMethod("getControlPanel", parameterTypes);
                OkJPanel panel = (OkJPanel)panelMethod.invoke(null, null);
                panelList.add(panel);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return panelList.toArray(new OkJPanel[0]);
    }

    private static IDataTypeComponent getDataTypeObject(JTable table, ColumnDisplayDefinition colDef) {
        String typeName;
        if (table != _table) {
            _colDataTypeObjects.clear();
            _table = table;
        }
        if (_colDataTypeObjects.containsKey(colDef)) {
            return (IDataTypeComponent)_colDataTypeObjects.get(colDef);
        }
        IDataTypeComponent dataTypeComponent = null;
        if (_registeredDataTypes.size() > 0 && _registeredDataTypes.containsKey(typeName = Integer.toString(colDef.getSqlType()) + ":" + colDef.getSqlTypeName())) {
            String handlerClassName = (String)_registeredDataTypes.get(typeName);
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                Class[] constClasses = new Class[]{Class.forName("java.swing.JTable"), colDef.getClass()};
                Constructor<?> handlerConst = handlerClass.getConstructor(constClasses);
                Object[] args = new Object[]{table, colDef};
                dataTypeComponent = (IDataTypeComponent)handlerConst.newInstance(args);
            }
            catch (Exception e) {
                s_log.warn("Could not find handler class named " + handlerClassName, e);
            }
        }
        if (dataTypeComponent == null) {
            switch (colDef.getSqlType()) {
                case 0: {
                    break;
                }
                case -7: 
                case 16: {
                    dataTypeComponent = new DataTypeBoolean(table, colDef);
                    break;
                }
                case 92: {
                    dataTypeComponent = new DataTypeTime(table, colDef);
                    break;
                }
                case 91: {
                    dataTypeComponent = new DataTypeDate(table, colDef);
                    break;
                }
                case 93: {
                    dataTypeComponent = new DataTypeTimestamp(table, colDef);
                    break;
                }
                case -5: {
                    dataTypeComponent = new DataTypeLong(table, colDef);
                    break;
                }
                case 6: 
                case 8: {
                    dataTypeComponent = new DataTypeDouble(table, colDef);
                    break;
                }
                case 7: {
                    dataTypeComponent = new DataTypeFloat(table, colDef);
                    break;
                }
                case 2: 
                case 3: {
                    dataTypeComponent = new DataTypeBigDecimal(table, colDef);
                    break;
                }
                case 4: {
                    dataTypeComponent = new DataTypeInteger(table, colDef);
                    break;
                }
                case 5: {
                    dataTypeComponent = new DataTypeShort(table, colDef);
                    break;
                }
                case -6: {
                    dataTypeComponent = new DataTypeByte(table, colDef);
                    break;
                }
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    dataTypeComponent = new DataTypeString(table, colDef);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    dataTypeComponent = new DataTypeBinary(table, colDef);
                    break;
                }
                case 2004: {
                    dataTypeComponent = new DataTypeBlob(table, colDef);
                    break;
                }
                case 2005: {
                    dataTypeComponent = new DataTypeClob(table, colDef);
                    break;
                }
                case 1111: {
                    dataTypeComponent = new DataTypeOther(table, colDef);
                    break;
                }
                default: {
                    dataTypeComponent = new DataTypeUnknown(table, colDef);
                }
            }
        }
        _colDataTypeObjects.put(colDef, dataTypeComponent);
        return dataTypeComponent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class CellRenderer
    extends DefaultTableCellRenderer {
        private final IDataTypeComponent _dataTypeObject;

        CellRenderer(IDataTypeComponent dataTypeObject) {
            this._dataTypeObject = dataTypeObject;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (this._dataTypeObject != null && !this._dataTypeObject.isEditableInCell(value) && this._dataTypeObject.isEditableInPopup(value)) {
                this.setBackground(Color.CYAN);
            } else if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            return label;
        }

        public void setValue(Object value) {
            if (this._dataTypeObject != null) {
                super.setValue(this._dataTypeObject.renderObject(value));
            } else {
                super.setValue(DefaultColumnRenderer.getInstance().renderObject(value));
            }
        }
    }
}

