/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

public class BinaryDisplayConverter {
    public static final int HEX = 16;
    public static final int DECIMAL = 10;
    public static final int OCTAL = 8;
    public static final int BINARY = 2;
    static ConversionConstants hex = new ConversionConstants(2, 16);
    static ConversionConstants decimal = new ConversionConstants(3, 10);
    private static ConversionConstants octal = new ConversionConstants(3, 8);
    private static ConversionConstants binary = new ConversionConstants(8, 2);
    private static String printable = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_=+[{]}\\|;:'\",<.>/?";

    private BinaryDisplayConverter() {
    }

    public static String convertToString(Byte[] data, int base, boolean showAscii) {
        if (data == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        ConversionConstants convConst = BinaryDisplayConverter.getConstants(base);
        for (int i = 0; i < data.length; ++i) {
            int value = data[i].byteValue();
            String s = null;
            if (showAscii && printable.indexOf((char)value) > -1) {
                s = new Character((char)value) + "          ".substring(10 - (convConst.width - 1));
            }
            if (s == null) {
                switch (base) {
                    case 10: {
                        if (value < 0) {
                            value = 256 + value;
                        }
                        s = Integer.toString(value);
                        break;
                    }
                    case 8: {
                        s = Integer.toOctalString(value);
                        break;
                    }
                    case 2: {
                        s = Integer.toBinaryString(value);
                        break;
                    }
                    default: {
                        s = Integer.toHexString(value);
                    }
                }
                if (s.length() > convConst.width) {
                    s = s.substring(s.length() - convConst.width);
                }
                if (s.length() < convConst.width) {
                    buf.append("00000000".substring(8 - (convConst.width - s.length())));
                }
            }
            buf.append(s);
            buf.append("  ");
        }
        return buf.toString();
    }

    public static Byte[] convertToBytes(String data, int base, boolean showAscii) throws NumberFormatException {
        ConversionConstants convConst = BinaryDisplayConverter.getConstants(base);
        if (data == null) {
            return null;
        }
        if (data.length() == 0) {
            return new Byte[0];
        }
        if (data.equals("<null>")) {
            return null;
        }
        int byteIndex = 0;
        Byte[] bytes = new Byte[(data.length() + 2) / (convConst.width + 2)];
        for (int stringIndex = 0; stringIndex < data.length(); stringIndex += convConst.width + 2) {
            String s = data.substring(stringIndex, stringIndex + convConst.width);
            bytes[byteIndex++] = showAscii && s.charAt(1) == ' ' ? new Byte((byte)s.charAt(0)) : new Byte((byte)Integer.valueOf(s, convConst.radix).intValue());
        }
        return bytes;
    }

    private static ConversionConstants getConstants(int base) {
        if (base == 16) {
            return hex;
        }
        if (base == 10) {
            return decimal;
        }
        if (base == 8) {
            return octal;
        }
        if (base == 2) {
            return binary;
        }
        return hex;
    }

    static class ConversionConstants {
        int width;
        int radix;

        ConversionConstants(int w, int r) {
            this.width = w;
            this.radix = r;
        }
    }
}

