/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowDataInputFrame;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.gui.BaseMDIParentFrame;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.gui.TablePopupMenu;

public class DataSetViewerEditableTablePanel
extends DataSetViewerTablePanel {
    TablePopupMenu cellPopupMenu = null;

    public void init(IDataSetUpdateableModel updateableModel) {
        super.init(updateableModel);
        this.setUpdateableModelReference(updateableModel);
    }

    public boolean isTableEditable() {
        return true;
    }

    public boolean isColumnEditable(int col, Object originalValue) {
        if (this._colDefs == null) {
            return false;
        }
        if (((IDataSetUpdateableTableModel)this.getUpdateableModel()).getRowidCol() == col) {
            return false;
        }
        return CellComponentFactory.isEditableInCell(this._colDefs[col], originalValue);
    }

    public void setCellEditors(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        this.cellPopupMenu = new TablePopupMenu(this.getUpdateableModel(), this, table);
        for (int i = 0; i < this._colDefs.length; ++i) {
            DefaultCellEditor editor = CellComponentFactory.getInCellEditor(table, this._colDefs[i]);
            editor.getComponent().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        DataSetViewerEditableTablePanel.this.cellPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }

                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        DataSetViewerEditableTablePanel.this.cellPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
            columnModel.getColumn(i).setCellEditor(editor);
        }
    }

    public boolean changeUnderlyingValueAt(int row, int col, Object newValue, Object oldValue) {
        int option;
        String message = null;
        if (this.getUpdateableModelReference() == null) {
            return false;
        }
        if (newValue == oldValue) {
            return true;
        }
        if (oldValue != null && newValue != null && CellComponentFactory.areEqual(this._colDefs[col], oldValue, newValue)) {
            return true;
        }
        if (this.getUpdateableModelReference() != null) {
            message = ((IDataSetUpdateableTableModel)this.getUpdateableModelReference()).getWarningOnCurrentData(this.getRow(row), this._colDefs, col, oldValue);
        }
        if (message != null && (option = JOptionPane.showConfirmDialog(null, message, "Warning", 0, 2)) != 0) {
            return false;
        }
        if (this.getUpdateableModelReference() != null) {
            message = ((IDataSetUpdateableTableModel)this.getUpdateableModelReference()).getWarningOnProjectedUpdate(this.getRow(row), this._colDefs, col, newValue);
        }
        if (message != null && (option = JOptionPane.showConfirmDialog(null, message, "Warning", 0, 2)) != 0) {
            return false;
        }
        message = ((IDataSetUpdateableTableModel)this.getUpdateableModelReference()).updateTableComponent(this.getRow(row), this._colDefs, col, oldValue, newValue);
        if (message != null) {
            JOptionPane.showMessageDialog(null, message, "Error", 0);
            return false;
        }
        return true;
    }

    public void deleteRows(int[] rows) {
        if (rows.length == 0) {
            JOptionPane.showMessageDialog(null, "You must select something in the table to delete.");
            return;
        }
        int option = JOptionPane.showConfirmDialog(null, "Do you wish to delete " + rows.length + (rows.length == 1 ? " row" : " rows") + " from this table?", "Warning", 0, 2);
        if (option != 0) {
            return;
        }
        if (this.currentCellEditor != null) {
            this.currentCellEditor.cancelCellEditing();
            this.currentCellEditor = null;
        }
        SortableTableModel tableModel = (SortableTableModel)((JTable)this.getComponent()).getModel();
        Object[][] rowData = new Object[rows.length][this._colDefs.length];
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < this._colDefs.length; ++j) {
                rowData[i][j] = tableModel.getValueAt(rows[i], j);
            }
        }
        String message = ((IDataSetUpdateableTableModel)this.getUpdateableModel()).deleteRows(rowData, this._colDefs);
        if (message != null) {
            JOptionPane.showMessageDialog(null, message + "\nNo rows deleted from database.", "Error", 0);
            return;
        }
        ((SortableTableModel)((DataSetViewerTablePanel.MyJTable)this.getComponent()).getModel()).deleteRows(rows);
    }

    public void insertRow() {
        JTable table = (JTable)this.getComponent();
        Point pt = new Point(10, 200);
        Component comp = SwingUtilities.getRoot(table);
        RowDataInputFrame newComp = null;
        String[] dbDefaultValues = ((IDataSetUpdateableTableModel)this.getUpdateableModelReference()).getDefaultValues(this._colDefs);
        Object[] initialValues = new Object[dbDefaultValues.length];
        for (int i = 0; i < initialValues.length; ++i) {
            initialValues[i] = CellComponentFactory.getDefaultValue(this._colDefs[i], dbDefaultValues[i]);
        }
        RowDataInputFrame rdif = new RowDataInputFrame(this._colDefs, initialValues, this);
        ((BaseMDIParentFrame)comp).addInternalFrame(rdif, false);
        rdif.setLayer(JLayeredPane.POPUP_LAYER);
        rdif.pack();
        newComp = rdif;
        Dimension dim = newComp.getSize();
        boolean dimChanged = false;
        if (dim.width < 300) {
            dim.width = 300;
            dimChanged = true;
        }
        if (dimChanged) {
            newComp.setSize(dim);
        }
        int fudgeFactor = 100;
        Rectangle parentBounds = comp.getBounds();
        if (parentBounds.width <= dim.width + fudgeFactor) {
            dim.width = parentBounds.width - fudgeFactor;
            pt.x = fudgeFactor / 2;
            newComp.setSize(dim);
        } else if (pt.x + dim.width + fudgeFactor > parentBounds.width) {
            pt.x -= pt.x + dim.width + fudgeFactor - parentBounds.width;
        }
        newComp.setLocation(pt);
        ((Component)newComp).setVisible(true);
    }

    protected String insertRow(Object[] values) {
        String message = ((IDataSetUpdateableTableModel)this.getUpdateableModelReference()).insertRow(values, this._colDefs);
        if (message != null) {
            JOptionPane.showMessageDialog(null, message, "Error", 0);
            return "Error";
        }
        SortableTableModel sortedModel = (SortableTableModel)((JTable)this.getComponent()).getModel();
        sortedModel.insertRow(values);
        return null;
    }
}

