/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.ODMGCollection;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import org.odmg.DBag;

public class Bag
extends ODMGCollection
implements DBag,
List {
    private List bag;

    public Bag(SessionImplementor session) {
        super(session);
    }

    public Bag(SessionImplementor session, Collection coll) {
        super(session);
        if (coll instanceof List) {
            this.bag = (List)coll;
        } else {
            this.bag = new ArrayList();
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                this.bag.add(iter.next());
            }
        }
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public Bag() {
    }

    public boolean isWrapper(Object collection) {
        return this.bag == collection;
    }

    public boolean empty() {
        return this.bag.isEmpty();
    }

    public Iterator entries() {
        return this.bag.iterator();
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.getSession());
        this.bag.add(element);
        return element;
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.getSession());
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.bag = new ArrayList();
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() != this.bag.size()) {
            return false;
        }
        Iterator iter = this.bag.iterator();
        while (iter.hasNext()) {
            Object elt = iter.next();
            if (this.countOccurrences(elt, this.bag, elementType) == this.countOccurrences(elt, sn, elementType)) continue;
            return false;
        }
        return true;
    }

    private int countOccurrences(Object element, List list, Type elementType) throws HibernateException {
        Iterator iter = list.iterator();
        int result = 0;
        while (iter.hasNext()) {
            if (!elementType.equals(element, iter.next())) continue;
            ++result;
        }
        return result;
    }

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        ArrayList<Object> clonedList = new ArrayList<Object>(this.bag.size());
        Iterator iter = this.bag.iterator();
        while (iter.hasNext()) {
            clonedList.add(persister.getElementType().deepCopy(iter.next()));
        }
        return clonedList;
    }

    public Collection getOrphans(Serializable snapshot) throws HibernateException {
        List sn = (List)((Object)snapshot);
        return PersistentCollection.getOrphans(sn, this.bag, this.getSession());
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = this.bag.size();
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            result[i] = persister.getElementType().disassemble(this.bag.get(i), this.getSession());
        }
        return result;
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        for (int i = 0; i < array.length; ++i) {
            this.bag.add(persister.getElementType().assemble(array[i], this.getSession(), owner));
        }
        this.setInitialized();
    }

    public boolean needsRecreate(CollectionPersister persister) {
        return !persister.isOneToMany();
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        ArrayList deletes = new ArrayList();
        List sn = (List)((Object)this.getSnapshot());
        Iterator olditer = sn.iterator();
        int i = 0;
        while (olditer.hasNext()) {
            Object old = olditer.next();
            Iterator newiter = this.bag.iterator();
            boolean found = false;
            if (this.bag.size() > i && elemType.equals(old, this.bag.get(i++))) {
                found = true;
            } else {
                while (newiter.hasNext()) {
                    if (!elemType.equals(old, newiter.next())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            deletes.add(old);
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        List sn = (List)((Object)this.getSnapshot());
        if (sn.size() > i && elemType.equals(sn.get(i), entry)) {
            return false;
        }
        Iterator olditer = sn.iterator();
        while (olditer.hasNext()) {
            Object old = olditer.next();
            if (!elemType.equals(old, entry)) continue;
            return false;
        }
        return true;
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) {
        return false;
    }

    public int size() {
        this.read();
        return this.bag.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.bag.isEmpty();
    }

    public boolean contains(Object o) {
        this.read();
        return this.bag.contains(o);
    }

    public Iterator iterator() {
        this.read();
        return new PersistentCollection.IteratorProxy(this, this.bag.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.bag.toArray();
    }

    public Object[] toArray(Object[] a) {
        this.read();
        return this.bag.toArray(a);
    }

    public boolean add(Object o) {
        if (!this.queueAdd(o)) {
            this.write();
            return this.bag.add(o);
        }
        return true;
    }

    public boolean remove(Object o) {
        this.write();
        return this.bag.remove(o);
    }

    public boolean containsAll(Collection c) {
        this.read();
        return this.bag.containsAll(c);
    }

    public boolean addAll(Collection c) {
        if (c.size() == 0) {
            return false;
        }
        if (!this.queueAddAll(c)) {
            this.write();
            return this.bag.addAll(c);
        }
        return c.size() > 0;
    }

    public void delayedAddAll(Collection c) {
        this.bag.addAll(c);
    }

    public boolean removeAll(Collection c) {
        if (c.size() > 0) {
            this.write();
            return this.bag.removeAll(c);
        }
        return false;
    }

    public boolean retainAll(Collection c) {
        this.write();
        return this.bag.retainAll(c);
    }

    public void clear() {
        this.write();
        this.bag.clear();
    }

    public Object getIndex(Object entry, int i) {
        throw new UnsupportedOperationException("Bags don't have indexes");
    }

    public DBag difference(DBag otherBag) {
        this.read();
        ArrayList list = new ArrayList(this.bag.size());
        list.addAll(this.bag);
        list.removeAll((Collection<?>)otherBag);
        return new Bag(this.getSession(), list);
    }

    public DBag intersection(DBag otherBag) {
        this.read();
        ArrayList list = new ArrayList(this.bag.size());
        list.addAll(this.bag);
        list.retainAll((Collection<?>)otherBag);
        return new Bag(this.getSession(), list);
    }

    public int occurrences(Object o) {
        this.read();
        Iterator iter = this.bag.iterator();
        int result = 0;
        while (iter.hasNext()) {
            if (!o.equals(iter.next())) continue;
            ++result;
        }
        return result;
    }

    public DBag union(DBag otherBag) {
        this.read();
        ArrayList list = new ArrayList(this.bag.size() + otherBag.size());
        list.addAll(otherBag);
        list.addAll(this.bag);
        return new Bag(this.getSession(), list);
    }

    public void add(int i, Object o) {
        this.write();
        this.bag.add(i, o);
    }

    public boolean addAll(int i, Collection c) {
        if (c.size() > 0) {
            this.write();
            return this.bag.addAll(i, c);
        }
        return false;
    }

    public Object get(int i) {
        this.read();
        return this.bag.get(i);
    }

    public int indexOf(Object o) {
        this.read();
        return this.bag.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        this.read();
        return this.bag.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        this.read();
        return new PersistentCollection.ListIteratorProxy(this, this.bag.listIterator());
    }

    public ListIterator listIterator(int i) {
        this.read();
        return new PersistentCollection.ListIteratorProxy(this, this.bag.listIterator(i));
    }

    public Object remove(int i) {
        this.write();
        return this.bag.remove(i);
    }

    public Object set(int i, Object o) {
        this.write();
        return this.bag.set(i, o);
    }

    public List subList(int start, int end) {
        this.read();
        return new PersistentCollection.ListProxy(this, this.bag.subList(start, end));
    }

    public String toString() {
        this.read();
        return this.bag.toString();
    }

    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

