/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.utility;

import java.net.URL;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sqlpanel.SQLTableSorter;
import net.sourceforge.sqlexplorer.sqlpanel.SqlTableContentProvider;
import net.sourceforge.sqlexplorer.sqlpanel.SqlTableLabelProvider;
import net.sourceforge.sqlexplorer.sqlpanel.SqlTableModel;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableConstructor {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TableViewer constructTable(SQLConnection conn, String sql, Composite parentComposite) {
        final Image imgAsc = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getAscOrderIcon()).createImage();
        final Image imgDesc = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getDescOrderIcon()).createImage();
        SqlTableModel stm = null;
        int count = 0;
        ResultSet set = null;
        TableViewer viewer = null;
        try {
            try {
                Statement st = conn.createStatement();
                set = st.executeQuery(sql);
                ResultSetReader reader = new ResultSetReader(set);
                ResultSetMetaData metaData = set.getMetaData();
                count = metaData.getColumnCount();
                viewer = new TableViewer(parentComposite, 65536);
                final Table table = viewer.getTable();
                final SQLTableSorter sorter = new SQLTableSorter(count, metaData);
                table.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        imgAsc.dispose();
                        imgDesc.dispose();
                    }
                });
                String[] ss = new String[count];
                viewer.setSorter((ViewerSorter)sorter);
                final TableViewer tmpViewer = viewer;
                SelectionAdapter headerListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int column = table.indexOf((TableColumn)e.widget);
                        if (column == sorter.getTopPriority()) {
                            int k = sorter.reverseTopPriority();
                            if (k == 1) {
                                ((TableColumn)e.widget).setImage(imgAsc);
                            } else {
                                ((TableColumn)e.widget).setImage(imgDesc);
                            }
                        } else {
                            sorter.setTopPriority(column);
                            ((TableColumn)e.widget).setImage(imgAsc);
                        }
                        TableColumn[] tcArr = table.getColumns();
                        int i = 0;
                        while (i < tcArr.length) {
                            if (i != column) {
                                tcArr[i].setImage(null);
                            }
                            ++i;
                        }
                        tmpViewer.refresh();
                    }
                };
                table.setLinesVisible(true);
                table.setHeaderVisible(true);
                viewer.setContentProvider((IContentProvider)new SqlTableContentProvider());
                int i = 0;
                while (true) {
                    if (i >= count) break;
                    TableColumn tc = new TableColumn(table, 0);
                    if (i == 0) {
                        tc.setImage(imgAsc);
                    }
                    tc.setText(metaData.getColumnLabel(i + 1));
                    ss[i] = new String(metaData.getColumnLabel(i + 1));
                    tc.addSelectionListener((SelectionListener)headerListener);
                    ++i;
                }
                viewer.setColumnProperties(ss);
                stm = new SqlTableModel(reader, metaData, 1000, conn, ss, sorter);
                SqlTableLabelProvider slp = new SqlTableLabelProvider(stm);
                viewer.setLabelProvider((IBaseLabelProvider)slp);
                viewer.setInput((Object)stm);
                int i2 = 0;
                while (true) {
                    if (i2 >= count) {
                        table.layout();
                    }
                    table.getColumn(i2).pack();
                    ++i2;
                }
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error((String)"Error creating table ", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            try {
                Statement st = set.getStatement();
                if (st != null) {
                    st.close();
                }
                set.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var19_24 = null;
        }
        try {}
        catch (Throwable throwable) {
            return viewer;
        }
        Statement st = set.getStatement();
        if (st != null) {
            st.close();
        }
        set.close();
        return viewer;
    }
}

