/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.dialogs;

import net.sourceforge.sqlexplorer.ext.oracle.dialogs.actions.GetErrors;
import net.sourceforge.sqlexplorer.ext.oracle.dialogs.actions.Save;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import net.sourceforge.sqlexplorer.sqlpanel.SQLTextViewer;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;

public class ObjectEditor
extends Dialog {
    ToolBarManager toolBarMgr;
    StatusLineManager statusMgr;
    SQLTextViewer vw;
    IPreferenceStore store;
    Dictionary dictionary;
    String text;
    String windowCaption;
    private Save saveAction;
    SQLConnection conn;
    String objectType;
    String owner;
    String objectName;
    StyledText st;
    CTabFolder tabFolder;
    boolean hiddenSaveButton = false;

    public void hideSaveButton() {
        this.hiddenSaveButton = true;
    }

    public ObjectEditor(Shell parentShell, IPreferenceStore store, Dictionary dictionary, String text, String windowCaption, SQLConnection conn, String objectType, String owner, String objectName) {
        super(parentShell);
        this.store = store;
        this.dictionary = dictionary;
        this.text = text;
        this.windowCaption = windowCaption;
        this.conn = conn;
        this.objectType = objectType;
        this.owner = owner;
        this.objectName = objectName;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.windowCaption);
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parentComposite.setLayout((Layout)layout);
        this.toolBarMgr = new ToolBarManager(0x800000);
        ToolBar toolBar = this.toolBarMgr.createControl(parentComposite);
        GridData gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        toolBar.setLayoutData((Object)gid);
        if (!this.hiddenSaveButton) {
            this.saveAction = new Save(this);
            this.toolBarMgr.add((IAction)this.saveAction);
            this.toolBarMgr.update(true);
        }
        gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        Composite cmp = new Composite(parentComposite, 0);
        cmp.setLayout((Layout)new FillLayout());
        this.tabFolder = new CTabFolder(cmp, 1024);
        CTabItem tabItem1 = new CTabItem(this.tabFolder, 0);
        tabItem1.setText("Code");
        if (this.objectName != null) {
            CTabItem tabItem2 = new CTabItem(this.tabFolder, 0);
            tabItem2.setText("Errors");
            this.st = new StyledText((Composite)this.tabFolder, 2816);
            this.st.setEditable(false);
            tabItem2.setControl((Control)this.st);
        }
        this.vw = new SQLTextViewer((Composite)this.tabFolder, 68354, this.store, this.dictionary);
        tabItem1.setControl(this.vw.getControl());
        this.tabFolder.setSelection(0);
        this.tabFolder.update();
        cmp.setLayoutData((Object)gid);
        this.statusMgr = new StatusLineManager();
        this.statusMgr.createControl(parentComposite);
        gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        this.statusMgr.getControl().setLayoutData((Object)gid);
        parentComposite.layout();
        Document dc = new Document(this.text);
        this.vw.setDocument((IDocument)dc);
        if (this.getObjectName() != null) {
            GetErrors getErrors = new GetErrors(this.getConn(), this.getOwner(), this.getObjectType(), this.getObjectName());
            getErrors.getError(this.st);
        }
        return parentComposite;
    }

    public SQLTextViewer getVw() {
        return this.vw;
    }

    public SQLConnection getConn() {
        return this.conn;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getOwner() {
        return this.owner;
    }

    public void showErrorPage() {
        this.tabFolder.setSelection(1);
    }

    public StyledText getSt() {
        return this.st;
    }
}

