/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.actions;

import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.ext.oracle.TriggerNode;
import net.sourceforge.sqlexplorer.ext.oracle.dialogs.ObjectEditor;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;

public class TriggerEdit
extends Action {
    IDbModel nd;
    private ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getSqlIcon());
    IPreferenceStore store;
    SessionTreeNode treeNode;

    public TriggerEdit(SessionTreeNode treeNode, IDbModel nd) {
        this.treeNode = treeNode;
        this.nd = nd;
        this.store = SQLExplorerPlugin.getDefault().getPreferenceStore();
    }

    public String getText() {
        return "Trigger Edit";
    }

    public void run() {
        try {
            TriggerNode tn = (TriggerNode)this.nd;
            String sql = "SELECT description,trigger_body FROM sys.all_triggers where owner=? and trigger_name=?";
            SQLConnection conn = this.treeNode.getConnection();
            PreparedStatement stmt = conn.prepareStatement("SELECT description,trigger_body FROM sys.all_triggers where owner=? and trigger_name=?");
            stmt.setString(1, tn.getOwner());
            stmt.setString(2, tn.toString());
            StringBuffer result = new StringBuffer(1000);
            ResultSet rs = null;
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.append("CREATE OR REPLACE TRIGGER ");
                result.append(String.valueOf(rs.getString(1)) + rs.getString(2));
            }
            rs.close();
            stmt.close();
            ObjectEditor oe = new ObjectEditor(null, this.store, this.treeNode.getDictionary(), result.toString(), "Editing " + tn.toString(), conn, "TRIGGER", tn.getOwner(), tn.toString());
            oe.open();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error((String)"Error opening trigger source", (Throwable)e);
        }
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return this.img;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }
}

