/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.actions;

import java.util.ArrayList;
import net.sourceforge.sqlexplorer.ext.oracle.ProcNode;
import net.sourceforge.sqlexplorer.ext.oracle.dialogs.RunProcWizard;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class RunProcedure
extends Action {
    SessionTreeNode sessionTreeNode;
    ProcNode node;

    public RunProcedure(SessionTreeNode sessionTreeNode, ProcNode node) {
        this.sessionTreeNode = sessionTreeNode;
        this.node = node;
    }

    public String getText() {
        return "Execute";
    }

    public void run() {
        if (!this.node.isValid()) {
            MessageDialog.openError(null, (String)"Can't Execute", (String)"The status is invalid");
            return;
        }
        ArrayList paramList = this.node.getParamInfoList();
        String sql = "{call " + this.node.getOwner() + "." + this.node.toString() + "(";
        int i = 0;
        while (i < paramList.size()) {
            sql = i == 0 ? String.valueOf(sql) + "?" : String.valueOf(sql) + ",?";
            ++i;
        }
        sql = String.valueOf(sql) + ")}";
        RunProcWizard rpw = new RunProcWizard(null, this.sessionTreeNode, this.node, sql, paramList);
        rpw.init(SQLExplorerPlugin.getDefault().getWorkbench(), null);
        WizardDialog runFunctionWizard = new WizardDialog(null, (IWizard)rpw){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10;
            }
        };
        runFunctionWizard.open();
    }
}

