/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ext.oracle.actions;

import java.util.ArrayList;
import net.sourceforge.sqlexplorer.ext.oracle.FunctionNode;
import net.sourceforge.sqlexplorer.ext.oracle.dialogs.RunFunctionWizard;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class RunFunction
extends Action {
    SessionTreeNode sessionTreeNode;
    FunctionNode node;

    public RunFunction(SessionTreeNode sessionTreeNode, FunctionNode node) {
        this.sessionTreeNode = sessionTreeNode;
        this.node = node;
    }

    public String getText() {
        return "Execute";
    }

    public void run() {
        if (!this.node.isValid()) {
            MessageDialog.openError(null, (String)"Can't Execute", (String)"The status is invalid");
            return;
        }
        ArrayList paramList = this.node.getParamInfoList();
        String sql = "{?=call " + this.node.getOwner() + "." + this.node.toString() + "(";
        int i = 1;
        while (i < paramList.size()) {
            sql = i == 1 ? String.valueOf(sql) + "?" : String.valueOf(sql) + ",?";
            ++i;
        }
        sql = String.valueOf(sql) + ")}";
        RunFunctionWizard rpw = new RunFunctionWizard(null, this.sessionTreeNode, this.node, sql, paramList);
        rpw.init(SQLExplorerPlugin.getDefault().getWorkbench(), null);
        WizardDialog runFunctionWizard = new WizardDialog(null, (IWizard)rpw){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10;
            }
        };
        runFunctionWizard.open();
    }
}

