/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.hbm2java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.jdom.Element;

public class MetaAttributeHelper {
    protected static MultiMap loadMetaMap(Element element) {
        MultiHashMap result = new MultiHashMap();
        ArrayList metaAttributeList = new ArrayList();
        metaAttributeList.addAll(element.getChildren("meta"));
        Iterator iter = metaAttributeList.iterator();
        while (iter.hasNext()) {
            Element metaAttrib = (Element)iter.next();
            String attribute = metaAttrib.getAttribute("attribute").getValue();
            String value = metaAttrib.getText();
            boolean inherit = Boolean.valueOf(metaAttrib.getAttributeValue("inherit"));
            MetaAttribute ma = new MetaAttribute(value, inherit);
            result.put((Object)attribute, (Object)ma);
        }
        return result;
    }

    public static MultiMap mergeMetaMaps(MultiMap local, MultiMap inherited) {
        MultiHashMap result = new MultiHashMap();
        if (inherited != null) {
            result.putAll((Map)local);
            Iterator iter = inherited.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (local.containsKey((Object)key)) continue;
                ArrayList ml = (ArrayList)inherited.get((Object)key);
                Iterator iterator = ml.iterator();
                while (iterator.hasNext()) {
                    MetaAttribute element = (MetaAttribute)iterator.next();
                    if (!element.inheritable) continue;
                    result.put((Object)key, (Object)element);
                }
            }
        }
        return result;
    }

    public static MultiMap loadAndMergeMetaMap(Element classElement, MultiMap inheritedMeta) {
        return MetaAttributeHelper.mergeMetaMaps(MetaAttributeHelper.loadMetaMap(classElement), inheritedMeta);
    }

    public static String getMetaAsString(Collection meta, String seperator) {
        StringBuffer buf = new StringBuffer();
        Iterator iter = meta.iterator();
        while (iter.hasNext()) {
            buf.append(seperator);
            buf.append(iter.next());
        }
        return buf.toString();
    }

    static boolean getMetaAsBool(Collection c, boolean defaultValue) {
        if (c == null || c.isEmpty()) {
            return defaultValue;
        }
        return Boolean.valueOf(c.iterator().next().toString());
    }

    static String getMetaAsString(Collection c) {
        if (c == null || c.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            sb.append(element.toString());
        }
        return sb.toString();
    }

    static class MetaAttribute {
        String value;
        boolean inheritable = true;

        MetaAttribute(String value, boolean inherit) {
            this.value = value;
            this.inheritable = inherit;
        }

        public String toString() {
            return this.value;
        }
    }
}

