/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.hbm2java;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.sqlexplorer.hbm2java.AbstractRenderer;
import net.sourceforge.sqlexplorer.hbm2java.ClassMapping;
import net.sourceforge.sqlexplorer.hbm2java.ClassName;
import net.sourceforge.sqlexplorer.hbm2java.Field;

public class FinderRenderer
extends AbstractRenderer {
    private static final String MT_FINDERMETHOD = "finder";
    static Map primitiveToObject = new HashMap();
    static Map hibType = new HashMap();

    public FinderRenderer() {
        primitiveToObject.put("char", "Character");
        primitiveToObject.put("byte", "Byte");
        primitiveToObject.put("short", "Short");
        primitiveToObject.put("int", "Integer");
        primitiveToObject.put("long", "Long");
        primitiveToObject.put("boolean", "Boolean");
        primitiveToObject.put("float", "Float");
        primitiveToObject.put("double", "Double");
        hibType.put("char", "Hibernate.CHARACTER");
        hibType.put("byte", "Hibernate.BYTE");
        hibType.put("short", "Hibernate.SHORT");
        hibType.put("int", "Hibernate.INTEGER");
        hibType.put("long", "Hibernate.LONG");
        hibType.put("boolean", "Hibernate.BOOLEAN");
        hibType.put("float", "Hibernate.FLOAT");
        hibType.put("double", "Hibernate.DOUBLE");
        hibType.put("String", "Hibernate.STRING");
    }

    public void render(String savedToPackage, String savedToClass, ClassMapping classMapping, Map class2classmap, PrintWriter mainwriter) throws Exception {
        if (savedToPackage != null && !savedToPackage.trim().equals("")) {
            mainwriter.println("package " + savedToPackage + ";");
        } else if (classMapping.getGeneratedPackageName() != null) {
            mainwriter.println("package " + classMapping.getGeneratedPackageName() + ";");
        } else {
            mainwriter.println("// default package");
        }
        mainwriter.println();
        StringWriter strWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(strWriter);
        writer.println("/** Automatically generated Finder class for " + savedToClass + ".\n" + " * @author Hibernate FinderGenerator " + " **/");
        String classScope = "public";
        writer.print(String.valueOf(classScope) + " class " + savedToClass);
        writer.print(" implements Serializable");
        writer.println(" {");
        writer.println();
        StringWriter strPropWriter = new StringWriter();
        PrintWriter propWriter = new PrintWriter(strPropWriter);
        this.doFinders(classMapping, class2classmap, propWriter);
        propWriter.println("}");
        writer.print(strPropWriter.toString());
        this.doImports(classMapping, mainwriter);
        mainwriter.print(strWriter.toString());
    }

    public void doFinders(ClassMapping classMapping, Map class2classmap, PrintWriter writer) {
        String sessionMethod = classMapping.getMetaAsString("session-method").trim();
        Iterator fields = classMapping.getFields().iterator();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            if (field.getMeta(MT_FINDERMETHOD) != null) {
                String finderName = field.getMetaAsString(MT_FINDERMETHOD);
                if ("".equals(sessionMethod)) {
                    writer.println("    public static List " + finderName + "(Session session, " + FinderRenderer.getTrueTypeName(field, class2classmap) + " " + field.getName() + ") " + "throws SQLException, HibernateException {");
                } else {
                    writer.println("    public static List " + finderName + "(" + FinderRenderer.getTrueTypeName(field, class2classmap) + " " + field.getName() + ") " + "throws SQLException, HibernateException {");
                    writer.println("        Session session = " + sessionMethod);
                }
                writer.println("        List finds = session.find(\"from " + classMapping.getName() + " in class " + classMapping.getPackageName() + "." + classMapping.getName() + " where " + classMapping.getName() + "." + field.getName() + "=?\", " + this.getFieldAsObject(false, field) + ", " + this.getFieldAsHibernateType(false, field) + ");");
                writer.println("        return finds;");
                writer.println("    }");
            }
            writer.println();
        }
        if ("".equals(sessionMethod)) {
            writer.println("    public static List findAll(Session session) throws SQLException, HibernateException {");
        } else {
            writer.println("    public static List findAll() throws SQLException, HibernateException {");
            writer.println("        Session session = " + sessionMethod);
        }
        writer.println("        List finds = session.find(\"from " + classMapping.getName() + " in class " + classMapping.getPackageName() + "." + classMapping.getName() + "\");");
        writer.println("        return finds;");
        writer.println("    }");
        writer.println();
    }

    public void doImports(ClassMapping classMapping, PrintWriter writer) {
        writer.println("import java.io.Serializable;");
        writer.println("import java.util.List;");
        writer.println("import java.sql.SQLException;");
        writer.println();
        writer.println("import net.sf.hibernate.*;");
        writer.println();
    }

    private String getFieldAsObject(boolean prependThis, Field field) {
        ClassName type = field.getClassType();
        if (type != null && type.isPrimitive() && !type.isArray()) {
            String typeName = (String)primitiveToObject.get(type.getName());
            typeName = "new " + typeName + "( ";
            typeName = String.valueOf(typeName) + (prependThis ? "this." : "");
            return String.valueOf(typeName) + field.getName() + " )";
        }
        return field.getName();
    }

    private String getFieldAsHibernateType(boolean prependThis, Field field) {
        ClassName type = field.getClassType();
        String hibTypeString = (String)hibType.get(type.getName());
        if (hibType != null) {
            return hibTypeString;
        }
        return "Hibernate.OBJECT";
    }
}

