/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.hbm2java;

import java.util.Collection;
import java.util.Set;
import net.sourceforge.sqlexplorer.hbm2java.ClassName;
import net.sourceforge.sqlexplorer.hbm2java.MetaAttributeHelper;
import org.apache.commons.collections.MultiMap;

public class Field {
    private String name = null;
    private String initialisation = null;
    private String asSuffix = null;
    private boolean id = false;
    private boolean generated = false;
    private boolean nullable = true;
    private ClassName classType;
    private MultiMap metaattribs = null;
    private ClassName foreignClass;
    private Set foreignKeys;

    public Field(String name, ClassName type, boolean nullable, MultiMap metaattribs) {
        this.initWith(name, type, name, nullable, this.id, this.generated, null, null, metaattribs);
    }

    public Field(String name, ClassName type, boolean nullable, boolean id, boolean generated, MultiMap metaattribs) {
        this.initWith(name, type, this.initialisation, nullable, id, generated, null, null, metaattribs);
    }

    public Field(String name, ClassName type, String initialisation, boolean nullable, ClassName foreignClass, Set foreignKeys, MultiMap metaattribs) {
        this.initWith(name, type, initialisation, nullable, this.id, this.generated, foreignClass, foreignKeys, metaattribs);
    }

    protected void initWith(String name, ClassName type, String initialisation, boolean nullable, boolean id, boolean generated, ClassName foreignClass, Set foreignKeys, MultiMap metaattribs) {
        this.name = name;
        this.setType(type);
        this.initialisation = initialisation;
        this.nullable = nullable;
        this.id = id;
        this.generated = generated;
        this.asSuffix = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        this.foreignClass = foreignClass;
        this.foreignKeys = foreignKeys;
        this.setMeta(metaattribs);
    }

    public String getInitialisation() {
        return this.initialisation;
    }

    public String getName() {
        return this.name;
    }

    public String getAsSuffix() {
        return this.asSuffix;
    }

    public String getGetterType() {
        return this.getType().toLowerCase().equals("boolean") ? "is" : "get";
    }

    public String getType() {
        String type = this.classType.getFullyQualifiedName();
        int loc = type.indexOf("java.lang.");
        if (loc < 0) {
            return type;
        }
        return type.substring(10);
    }

    public boolean isIdentifier() {
        return this.id;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public String toString() {
        return String.valueOf(this.getType()) + ":" + this.getName();
    }

    public ClassName getClassType() {
        return this.classType;
    }

    private void setType(ClassName type) {
        this.classType = type;
    }

    private void setMeta(MultiMap multiMap) {
        this.metaattribs = multiMap;
    }

    Collection getMeta(String attribute) {
        return (Collection)this.metaattribs.get((Object)attribute);
    }

    public String getMetaAsString(String attribute) {
        Collection c = this.getMeta(attribute);
        return MetaAttributeHelper.getMetaAsString(c);
    }

    public boolean getMetaAsBool(String attribute) {
        return this.getMetaAsBool(attribute, false);
    }

    public boolean getMetaAsBool(String attribute, boolean defaultValue) {
        Collection c = this.getMeta(attribute);
        return MetaAttributeHelper.getMetaAsBool(c, defaultValue);
    }

    public ClassName getForeignClass() {
        return this.foreignClass;
    }

    public void setForeignClass(ClassName foreignClass) {
        this.foreignClass = foreignClass;
    }

    public Set getForeignKeys() {
        return this.foreignKeys;
    }

    public String getGetterSignature() {
        return String.valueOf(this.getGetterType()) + this.getAsSuffix() + "()";
    }

    public boolean isGeneratedAsProperty() {
        return this.getMetaAsBool("gen-property", true);
    }
}

