/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.hbm2java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.hibernate.UserType;
import net.sf.hibernate.type.PrimitiveType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.ReflectHelper;
import net.sourceforge.sqlexplorer.hbm2java.ClassName;
import net.sourceforge.sqlexplorer.hbm2java.Field;
import net.sourceforge.sqlexplorer.hbm2java.MetaAttributeHelper;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Element;

public class ClassMapping {
    private static Log log;
    private ClassName name = null;
    private ClassName generatedName = null;
    private String superClass = null;
    private ClassMapping superClassMapping = null;
    private String proxyClass = null;
    private List fields = new ArrayList();
    private TreeSet imports = new TreeSet();
    private List subclasses = new ArrayList();
    private static final Map components;
    private boolean mustImplementEquals = false;
    private MultiMap metaattribs;
    private boolean shouldBeAbstract = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.hbm2java.ClassMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        components = new HashMap();
    }

    public ClassMapping(ClassName superClass, ClassMapping superClassMapping, Element classElement, MultiMap inheritedMeta) throws Exception {
        this(superClass, classElement, inheritedMeta);
        this.superClassMapping = superClassMapping;
        if (this.superClassMapping != null) {
            List l = this.superClassMapping.getAllFieldsForFullConstructor();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                Field element = (Field)iter.next();
                ClassName ct = element.getClassType();
                if (ct != null) {
                    this.addImport(ct);
                    continue;
                }
                this.addImport(element.getType());
            }
        }
    }

    public ClassMapping(ClassName superClass, Element classElement, MultiMap inheritedMeta) throws Exception {
        this.initWith(superClass, classElement, false, inheritedMeta);
    }

    public ClassMapping(Element classElement, MultiMap inheritedMeta) throws Exception {
        this.initWith(null, classElement, false, inheritedMeta);
    }

    public ClassMapping(Element classElement, boolean component, MultiMap inheritedMeta) throws Exception {
        this.initWith(null, classElement, component, inheritedMeta);
    }

    protected void initWith(ClassName superClass, Element classElement, boolean component, MultiMap inheritedMeta) throws Exception {
        ClassMapping subclassMapping;
        Element subclass;
        String name;
        Element cmpid;
        Element id;
        String fullyQualifiedName = classElement.getAttributeValue(component ? "class" : "name");
        log.debug((Object)("Processing mapping for class: " + fullyQualifiedName));
        this.setMetaAttribs(MetaAttributeHelper.loadAndMergeMetaMap(classElement, inheritedMeta));
        this.name = new ClassName();
        this.name.setFullyQualifiedName(fullyQualifiedName);
        if (this.getMeta("generated-class") != null) {
            this.generatedName = new ClassName();
            this.generatedName.setFullyQualifiedName(this.getMetaAsString("generated-class").trim());
            this.shouldBeAbstract = true;
            log.warn((Object)("Generating " + this.generatedName + " instead of " + this.name));
        } else {
            this.generatedName = this.name;
        }
        if (superClass != null) {
            this.superClass = superClass.getName();
            this.addImport(superClass);
        }
        ArrayList<Element> propertyList = new ArrayList<Element>();
        propertyList.addAll(classElement.getChildren("property"));
        propertyList.addAll(classElement.getChildren("version"));
        propertyList.addAll(classElement.getChildren("timestamp"));
        propertyList.addAll(classElement.getChildren("key-property"));
        propertyList.addAll(classElement.getChildren("any"));
        ArrayList manyToOneList = new ArrayList();
        manyToOneList.addAll(classElement.getChildren("many-to-one"));
        manyToOneList.addAll(classElement.getChildren("key-many-to-one"));
        Attribute att = classElement.getAttribute("proxy");
        if (att != null) {
            this.proxyClass = att.getValue();
        }
        if ((id = classElement.getChild("id")) != null) {
            propertyList.add(0, id);
            this.implementEquals();
        }
        if ((cmpid = classElement.getChild("composite-id")) != null) {
            this.implementEquals();
            String cmpname = cmpid.getAttributeValue("name");
            String cmpclass = cmpid.getAttributeValue("class");
            if (cmpclass == null || cmpclass.equals("")) {
                propertyList.addAll(0, cmpid.getChildren("key-property"));
                manyToOneList.addAll(0, cmpid.getChildren("key-many-to-one"));
            } else {
                ClassMapping mapping = new ClassMapping(cmpid, true, this.metaattribs);
                MultiMap metaForCompositeid = MetaAttributeHelper.loadAndMergeMetaMap(cmpid, this.metaattribs);
                mapping.implementEquals();
                ClassName classType = new ClassName();
                classType.setFullyQualifiedName(cmpclass);
                this.addImport(classType);
                Field cmpidfield = new Field(cmpname, classType, false, true, false, metaForCompositeid);
                this.fields.add(cmpidfield);
                components.put(mapping.getCanonicalName(), mapping);
            }
        }
        Iterator properties = propertyList.iterator();
        while (properties.hasNext()) {
            Element column;
            Element property = (Element)properties.next();
            MultiMap metaForProperty = MetaAttributeHelper.loadAndMergeMetaMap(property, this.metaattribs);
            String name2 = property.getAttributeValue("name");
            if (name2 == null || name2.trim().equals("")) continue;
            String type = property.getAttributeValue("type");
            if (type == null && cmpid != null) {
                type = property.getAttributeValue("class");
            }
            if ("timestamp".equals(property.getName())) {
                type = "java.util.Date";
            }
            if ("any".equals(property.getName())) {
                type = "java.lang.Object";
            }
            if (type == null || type.trim().equals("")) {
                log.warn((Object)("property \"" + name2 + "\" in class " + this.getName() + " is missing a type attribute"));
                continue;
            }
            if (property == id) {
                Element generator = property.getChild("generator");
                String unsavedValue = property.getAttributeValue("unsaved-value");
                boolean needObject = unsavedValue != null && unsavedValue.equals("null");
                boolean generated = !generator.getAttributeValue("class").equals("assigned");
                Field idField = new Field(name2, this.getFieldType(type, needObject), false, true, generated, metaForProperty);
                this.fields.add(idField);
                continue;
            }
            String notnull = property.getAttributeValue("not-null");
            if (notnull == null && (column = property.getChild("column")) != null) {
                notnull = column.getAttributeValue("not-null");
            }
            boolean nullable = notnull == null || notnull.equals("false");
            boolean key = property.getName().startsWith("key-");
            Field stdField = new Field(name2, this.getFieldType(type), nullable && !key, key, false, metaForProperty);
            this.fields.add(stdField);
        }
        List onetooneList = classElement.getChildren("one-to-one");
        Iterator onetoones = onetooneList.iterator();
        while (onetoones.hasNext()) {
            Element onetoone = (Element)onetoones.next();
            MultiMap metaForOneToOne = MetaAttributeHelper.loadAndMergeMetaMap(onetoone, this.metaattribs);
            name = onetoone.getAttributeValue("name");
            String clazz = onetoone.getAttributeValue("class");
            if (StringUtils.isEmpty((String)clazz)) {
                log.warn((Object)("one-to-one \"" + name + "\" in class " + this.getName() + " is missing a class attribute"));
                continue;
            }
            Field fm = new Field(name, this.getFieldType(clazz), true, metaForOneToOne);
            this.fields.add(fm);
        }
        Iterator manytoOnes = manyToOneList.iterator();
        while (manytoOnes.hasNext()) {
            Element manyToOne = (Element)manytoOnes.next();
            MultiMap metaForManyToOne = MetaAttributeHelper.loadAndMergeMetaMap(manyToOne, this.metaattribs);
            name = manyToOne.getAttributeValue("name");
            String type = manyToOne.getAttributeValue("class");
            if (StringUtils.isEmpty((String)type)) {
                log.warn((Object)("many-to-one \"" + name + "\" in class " + this.getName() + " is missing a class attribute"));
                continue;
            }
            ClassName classType = new ClassName();
            classType.setFullyQualifiedName(type);
            String notnull = manyToOne.getAttributeValue("not-null");
            boolean nullable = notnull == null || notnull.equals("false");
            boolean key = manyToOne.getName().startsWith("key-");
            this.addImport(classType);
            Field f = new Field(name, classType, nullable && !key, key, false, metaForManyToOne);
            this.fields.add(f);
        }
        this.doCollections(classElement, "list", "java.util.List", "java.util.ArrayList", this.metaattribs);
        this.doCollections(classElement, "map", "java.util.Map", "java.util.HashMap", this.metaattribs);
        this.doCollections(classElement, "set", "java.util.Set", "java.util.HashSet", this.metaattribs);
        this.doCollections(classElement, "bag", "java.util.Collection", "java.util.ArrayList", this.metaattribs);
        this.doArrays(classElement, "array", this.metaattribs);
        this.doArrays(classElement, "primitive-array", this.metaattribs);
        Iterator iter = classElement.getChildren("component").iterator();
        while (iter.hasNext()) {
            Element cmpe = (Element)iter.next();
            MultiMap metaForComponent = MetaAttributeHelper.loadAndMergeMetaMap(cmpe, this.metaattribs);
            String cmpname = cmpe.getAttributeValue("name");
            String cmpclass = cmpe.getAttributeValue("class");
            if (cmpclass == null || cmpclass.equals("")) {
                log.warn((Object)("component \"" + cmpname + "\" in class " + this.getName() + " does not specify a class"));
                continue;
            }
            ClassMapping mapping = new ClassMapping(cmpe, true, this.metaattribs);
            ClassName classType = new ClassName();
            classType.setFullyQualifiedName(cmpclass);
            this.addImport(classType);
            Field ff = new Field(cmpname, classType, false, metaForComponent);
            this.fields.add(ff);
            components.put(mapping.getCanonicalName(), mapping);
        }
        iter = classElement.getChildren("subclass").iterator();
        while (iter.hasNext()) {
            subclass = (Element)iter.next();
            subclassMapping = new ClassMapping(this.name, this, subclass, this.metaattribs);
            this.subclasses.add(subclassMapping);
        }
        iter = classElement.getChildren("joined-subclass").iterator();
        while (iter.hasNext()) {
            subclass = (Element)iter.next();
            subclassMapping = new ClassMapping(this.name, this, subclass, this.metaattribs);
            this.subclasses.add(subclassMapping);
        }
        this.validateMetaAttribs();
    }

    private void setMetaAttribs(MultiMap multiMap) {
        this.metaattribs = multiMap;
    }

    public void implementEquals() {
        this.mustImplementEquals = true;
    }

    public boolean mustImplementEquals() {
        return this.mustImplementEquals;
    }

    public List getFields() {
        return this.fields;
    }

    public TreeSet getImports() {
        return this.imports;
    }

    public String getCanonicalName() {
        return this.name.getFullyQualifiedName();
    }

    public String getName() {
        return this.name.getName();
    }

    public String getGeneratedName() {
        return this.generatedName.getName();
    }

    public String getProxy() {
        return this.proxyClass;
    }

    public String getPackageName() {
        return this.name.getPackageName();
    }

    public String getGeneratedPackageName() {
        return this.generatedName.getPackageName();
    }

    public List getSubclasses() {
        return this.subclasses;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public boolean needsMinimalConstructor() {
        boolean generatedId = true;
        boolean missingId = true;
        int countNull = 0;
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            Field f = (Field)it.next();
            if (f.isIdentifier()) {
                generatedId = f.isGenerated();
                missingId = false;
                continue;
            }
            if (!f.isNullable()) continue;
            ++countNull;
        }
        return !(countNull == 0 || countNull == this.fields.size() - 1 && generatedId || countNull == this.fields.size() && missingId);
    }

    public List getLocalFieldsForFullConstructor() {
        ArrayList<Field> result = new ArrayList<Field>();
        Iterator fields = this.getFields().iterator();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            if (field.isIdentifier() && (!field.isIdentifier() || field.isGenerated())) continue;
            result.add(field);
        }
        return result;
    }

    public List getFieldsForSupersFullConstructor() {
        ArrayList result = new ArrayList();
        if (this.getSuperClassMapping() != null) {
            result.addAll(this.getSuperClassMapping().getFieldsForSupersFullConstructor());
            result.addAll(this.getSuperClassMapping().getLocalFieldsForFullConstructor());
        }
        return result;
    }

    public List getLocalFieldsForMinimalConstructor() {
        ArrayList<Field> result = new ArrayList<Field>();
        Iterator fields = this.getFields().iterator();
        while (fields.hasNext()) {
            Field field = (Field)fields.next();
            if ((field.isIdentifier() || field.isNullable()) && (!field.isIdentifier() || field.isGenerated())) continue;
            result.add(field);
        }
        return result;
    }

    public List getAllFields() {
        ArrayList result = new ArrayList();
        if (this.getSuperClassMapping() != null) {
            result.addAll(this.getSuperClassMapping().getAllFields());
        } else {
            result.addAll(this.getFields());
        }
        return result;
    }

    public List getAllFieldsForFullConstructor() {
        List result = this.getFieldsForSupersFullConstructor();
        result.addAll(this.getLocalFieldsForFullConstructor());
        return result;
    }

    public List getFieldsForSupersMinimalConstructor() {
        ArrayList result = new ArrayList();
        if (this.getSuperClassMapping() != null) {
            result.addAll(this.getSuperClassMapping().getFieldsForSupersMinimalConstructor());
            result.addAll(this.getSuperClassMapping().getLocalFieldsForMinimalConstructor());
        }
        return result;
    }

    public List getAllFieldsForMinimalConstructor() {
        List result = this.getFieldsForSupersMinimalConstructor();
        result.addAll(this.getLocalFieldsForMinimalConstructor());
        return result;
    }

    public void addImport(ClassName className) {
        if (!(className.inJavaLang() || className.inSamePackage(this.generatedName) || className.isPrimitive())) {
            if (className.isArray()) {
                this.imports.add(className.getFullyQualifiedName().substring(0, className.getFullyQualifiedName().length() - 2));
            } else {
                this.imports.add(className.getFullyQualifiedName());
            }
        }
    }

    public void addImport(String className) {
        ClassName cn = new ClassName();
        cn.setFullyQualifiedName(className);
        this.addImport(cn);
    }

    public static Iterator getComponents() {
        return components.values().iterator();
    }

    private void doCollections(Element classElement, String xmlName, String interfaceClass, String implementingClass, MultiMap inheritedMeta) {
        ClassName interfaceClassName = new ClassName();
        ClassName implementingClassName = new ClassName();
        interfaceClassName.setFullyQualifiedName(interfaceClass);
        implementingClassName.setFullyQualifiedName(implementingClass);
        Iterator collections = classElement.getChildren(xmlName).iterator();
        while (collections.hasNext()) {
            Element collection = (Element)collections.next();
            MultiMap metaForCollection = MetaAttributeHelper.loadAndMergeMetaMap(collection, inheritedMeta);
            String name = collection.getAttributeValue("name");
            this.addImport(interfaceClassName);
            ClassName foreignClass = null;
            HashSet<String> foreignKeys = null;
            if (collection.getChildren("one-to-many").size() != 0) {
                foreignClass = new ClassName();
                foreignClass.setFullyQualifiedName(collection.getChild("one-to-many").getAttributeValue("class"));
            } else if (collection.getChildren("many-to-many").size() != 0) {
                foreignClass = new ClassName();
                foreignClass.setFullyQualifiedName(collection.getChild("many-to-many").getAttributeValue("class"));
            }
            if (foreignClass != null) {
                foreignKeys = new HashSet<String>();
                foreignKeys.add(collection.getChild("key").getAttributeValue("column"));
                Iterator iter = collection.getChild("key").getChildren("column").iterator();
                while (iter.hasNext()) {
                    foreignKeys.add(((Element)iter.next()).getAttributeValue("name"));
                }
                this.addImport(foreignClass);
            }
            Field cf = new Field(name, interfaceClassName, "new " + implementingClassName.getName() + "()", false, foreignClass, foreignKeys, metaForCollection);
            this.fields.add(cf);
            if (collection.getChildren("composite-element") == null) continue;
            Iterator compositeElements = collection.getChildren("composite-element").iterator();
            while (compositeElements.hasNext()) {
                Element compositeElement = (Element)compositeElements.next();
                String compClass = compositeElement.getAttributeValue("class");
                try {
                    ClassMapping mapping = new ClassMapping(compositeElement, true, this.metaattribs);
                    ClassName classType = new ClassName();
                    classType.setFullyQualifiedName(compClass);
                    this.addImport(classType);
                    components.put(mapping.getCanonicalName(), mapping);
                }
                catch (Exception e) {
                    log.error((Object)("Error building composite-element " + compClass), (Throwable)e);
                }
            }
        }
    }

    private void doArrays(Element classElement, String type, MultiMap inheritedMeta) {
        Iterator arrays = classElement.getChildren(type).iterator();
        while (arrays.hasNext()) {
            Element array = (Element)arrays.next();
            MultiMap metaForArray = MetaAttributeHelper.loadAndMergeMetaMap(array, inheritedMeta);
            String role = array.getAttributeValue("name");
            String elementClass = array.getAttributeValue("element-class");
            if (elementClass == null) {
                Element elt = array.getChild("element");
                if (elt == null) {
                    elt = array.getChild("one-to-many");
                }
                if (elt == null) {
                    elt = array.getChild("many-to-many");
                }
                if (elt == null) {
                    elt = array.getChild("composite-element");
                }
                if (elt == null) {
                    log.warn((Object)"skipping collection with subcollections");
                    continue;
                }
                elementClass = elt.getAttributeValue("type");
                if (elementClass == null) {
                    elementClass = elt.getAttributeValue("class");
                }
            }
            ClassName cn = this.getFieldType(elementClass);
            cn.setFullyQualifiedName(String.valueOf(cn.getFullyQualifiedName()) + "[]", cn.isPrimitive());
            cn.setIsArray(true);
            Field af = new Field(role, cn, false, metaForArray);
            this.fields.add(af);
        }
    }

    private ClassName getFieldType(String hibernateType) {
        return this.getFieldType(hibernateType, false);
    }

    private ClassName getFieldType(String hibernateType, boolean needObject) {
        ClassName cn = new ClassName();
        if (hibernateType.equals("binary")) {
            cn.setFullyQualifiedName("byte[]", true);
            cn.setIsArray(true);
            return cn;
        }
        Type basicType = TypeFactory.basic((String)hibernateType);
        if (basicType != null) {
            if (basicType instanceof PrimitiveType && !hibernateType.trim().equals(basicType.getReturnedClass().getName()) && !needObject) {
                cn.setFullyQualifiedName(((PrimitiveType)basicType).getPrimitiveClass().getName(), true);
                return cn;
            }
            cn.setFullyQualifiedName(basicType.getReturnedClass().getName());
            return cn;
        }
        hibernateType = this.getTypeForUserType(hibernateType);
        ClassName classType = new ClassName();
        classType.setFullyQualifiedName(hibernateType);
        this.addImport(classType);
        return classType;
    }

    private String getTypeForUserType(String type) {
        Class clazz = null;
        try {
            clazz = ReflectHelper.classForName((String)type);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("net.sf.hibernate.UserType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.isAssignableFrom(clazz)) {
                UserType ut = (UserType)clazz.newInstance();
                log.debug((Object)("Resolved usertype: " + type + " to " + ut.returnedClass().getName()));
                String t = this.clazzToName(ut.returnedClass());
                return t;
            }
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Could not find UserType: " + type + ". Using the type '" + type + "' directly instead. (" + e.toString() + ")"));
        }
        catch (IllegalAccessException iae) {
            log.warn((Object)("Error while trying to resolve UserType. Using the type '" + type + "' directly instead. (" + iae.toString() + ")"));
        }
        catch (InstantiationException e) {
            log.warn((Object)("Error while trying to resolve UserType. Using the type '" + type + "' directly instead. (" + e.toString() + ")"));
        }
        return type;
    }

    private String clazzToName(Class cl) {
        String s = null;
        s = cl.isArray() ? String.valueOf(this.clazzToName(cl.getComponentType())) + "[]" : cl.getName();
        return s;
    }

    public ClassMapping getSuperClassMapping() {
        return this.superClassMapping;
    }

    Collection getMeta(String attribute) {
        return (Collection)this.metaattribs.get((Object)attribute);
    }

    public String getMetaAsString(String attribute) {
        Collection c = this.getMeta(attribute);
        return MetaAttributeHelper.getMetaAsString(c);
    }

    public boolean shouldBeAbstract() {
        return this.shouldBeAbstract;
    }

    void validateMetaAttribs() {
        if (this.getSuperClass() != null && this.getMeta("extends") != null) {
            log.warn((Object)("Warning: meta attribute extends='" + this.getMetaAsString("extends") + "' will be ignored for subclass " + this.name));
        }
    }

    public String toString() {
        return "ClassMapping: " + this.name.getFullyQualifiedName();
    }
}

