/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.hbm2java;

import java.util.Map;
import java.util.TreeSet;
import net.sourceforge.sqlexplorer.hbm2java.ClassMapping;
import net.sourceforge.sqlexplorer.hbm2java.ClassName;
import net.sourceforge.sqlexplorer.hbm2java.Field;
import net.sourceforge.sqlexplorer.hbm2java.Renderer;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractRenderer
implements Renderer {
    protected static String getTrueTypeName(Field field, Map class2classmap) {
        String name = field.getClassType() != null ? field.getClassType().getFullyQualifiedName() : field.getType();
        ClassMapping cmap = (ClassMapping)class2classmap.get(name);
        if (cmap != null && cmap.getProxy() != null) {
            return cmap.getProxy();
        }
        return name;
    }

    protected static String getTrueTypeName(ClassName cn, Map class2classmap) {
        String name = cn.getFullyQualifiedName();
        ClassMapping cmap = (ClassMapping)class2classmap.get(name);
        if (cmap != null && cmap.getProxy() != null) {
            return cmap.getProxy();
        }
        return name;
    }

    protected String shortenType(String type, TreeSet imports) {
        if (imports.contains(type)) {
            return type.substring(type.lastIndexOf(46) + 1);
        }
        if (type.endsWith("[]")) {
            return String.valueOf(this.shortenType(type.substring(0, type.length() - 2), imports)) + "[]";
        }
        return type;
    }

    protected String toJavaDoc(String string, int indent) {
        StringBuffer result = new StringBuffer();
        if (string != null) {
            String[] lines = StringUtils.split((String)string, (String)"\n\r\f");
            int i = 0;
            while (i < lines.length) {
                String docline = " * " + lines[i] + "\n";
                result.append(StringUtils.leftPad((String)docline, (int)(docline.length() + indent)));
                ++i;
            }
        }
        return result.toString();
    }

    public String getFieldScope(Field field, String localScopeName, String defaultScope) {
        if (defaultScope == null) {
            defaultScope = "private";
        }
        return field.getMeta(localScopeName) == null ? defaultScope : field.getMetaAsString(localScopeName);
    }
}

