/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.ddl2hbm;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.type.NullableType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCUtil {
    private static final Log logger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.ddl2hbm.JDBCUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public static List getCatalogs(Connection c) throws SQLException {
        LinkedList<String> linkedList;
        block3: {
            DatabaseMetaData dmd = c.getMetaData();
            ResultSet rs = null;
            try {
                rs = dmd.getCatalogs();
                LinkedList<String> l = new LinkedList<String>();
                while (rs.next()) {
                    l.add(rs.getString(1));
                }
                linkedList = l;
                Object var4_5 = null;
                if (rs == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_6 = null;
                    if (rs == null) break block4;
                    rs.close();
                }
                throw throwable;
            }
            rs.close();
        }
        return linkedList;
    }

    public static Map getSchemas(Connection c) throws SQLException {
        HashMap<String, LinkedList<String>> hashMap;
        block5: {
            DatabaseMetaData dmd = c.getMetaData();
            ResultSet rs = null;
            try {
                rs = dmd.getSchemas();
                HashMap<String, LinkedList<String>> map = new HashMap<String, LinkedList<String>>();
                while (rs.next()) {
                    LinkedList<String> l;
                    String schema = rs.getString(1);
                    String catalog = null;
                    if (rs.getMetaData().getColumnCount() > 1) {
                        catalog = rs.getString(2);
                    }
                    if ((l = (LinkedList<String>)map.get(catalog)) == null) {
                        l = new LinkedList<String>();
                        map.put(catalog, l);
                    }
                    l.add(schema);
                }
                hashMap = map;
                Object var7_8 = null;
                if (rs == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var7_9 = null;
                    if (rs == null) break block6;
                    rs.close();
                }
                throw throwable;
            }
            rs.close();
        }
        return hashMap;
    }

    public static List getTables(Connection c, String catalog, String schema, String tablePattern) throws SQLException {
        LinkedList<String> linkedList;
        block3: {
            logger.debug((Object)("catalog='" + catalog + "'"));
            logger.debug((Object)("schema='" + schema + "'"));
            logger.debug((Object)("table='" + tablePattern + "'"));
            DatabaseMetaData dmd = c.getMetaData();
            ResultSet rs = null;
            try {
                rs = dmd.getTables(catalog, schema, tablePattern, new String[]{"TABLE", "VIEW", "SYNONYM", "ALIAS"});
                LinkedList<String> l = new LinkedList<String>();
                while (rs.next()) {
                    l.add(rs.getString(3));
                }
                linkedList = l;
                Object var7_8 = null;
                if (rs == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_9 = null;
                    if (rs == null) break block4;
                    rs.close();
                }
                throw throwable;
            }
            rs.close();
        }
        return linkedList;
    }

    public static Set getForeignKeyColumns(Connection c, String catalog, String schema, String table) throws SQLException {
        HashSet<String> hashSet;
        block3: {
            logger.debug((Object)("catalog='" + catalog + "'"));
            logger.debug((Object)("schema='" + schema + "'"));
            logger.debug((Object)("table='" + table + "'"));
            DatabaseMetaData dmd = c.getMetaData();
            ResultSet rs = null;
            try {
                rs = dmd.getImportedKeys(catalog, schema, table);
                HashSet<String> columns = new HashSet<String>();
                while (rs.next()) {
                    columns.add(rs.getString(8));
                }
                hashSet = columns;
                Object var7_8 = null;
                if (rs == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var7_9 = null;
                    if (rs == null) break block4;
                    rs.close();
                }
                throw throwable;
            }
            rs.close();
        }
        return hashSet;
    }

    public static List getPrimaryKeyColumns(Connection c, String catalog, String schema, String table) throws SQLException {
        LinkedList<Column> linkedList;
        block3: {
            logger.debug((Object)("catalog='" + catalog + "'"));
            logger.debug((Object)("schema='" + schema + "'"));
            logger.debug((Object)("table='" + table + "'"));
            DatabaseMetaData dmd = c.getMetaData();
            ResultSet rs = null;
            try {
                rs = dmd.getPrimaryKeys(catalog, schema, table);
                LinkedList<Column> pkColumns = new LinkedList<Column>();
                while (rs.next()) {
                    List tmp = JDBCUtil.getTableColumns(c, catalog, schema, table, rs.getString(4));
                    Column pkColumn = (Column)tmp.get(0);
                    pkColumns.add(pkColumn);
                }
                linkedList = pkColumns;
                Object var9_10 = null;
                if (rs == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var9_11 = null;
                    if (rs == null) break block4;
                    rs.close();
                }
                throw throwable;
            }
            rs.close();
        }
        return linkedList;
    }

    public static List getTableColumns(Connection c, String catalog, String schema, String table) throws SQLException {
        return JDBCUtil.getTableColumns(c, catalog, schema, table, null);
    }

    public static List getTableColumns(Connection c, String catalog, String schema, String table, String columnPattern) throws SQLException {
        LinkedList<Column> linkedList;
        block3: {
            logger.debug((Object)("catalog='" + catalog + "'"));
            logger.debug((Object)("schema='" + schema + "'"));
            logger.debug((Object)("table='" + table + "'"));
            logger.debug((Object)("column='" + columnPattern + "'"));
            DatabaseMetaData dmd = c.getMetaData();
            ResultSet rs = null;
            try {
                rs = dmd.getColumns(catalog, schema, table, columnPattern);
                LinkedList<Column> columns = new LinkedList<Column>();
                while (rs.next()) {
                    Column aCol = new Column();
                    aCol.name = rs.getString(4);
                    aCol.sqlType = rs.getShort(5);
                    aCol.sqlColumnLength = rs.getInt(7);
                    aCol.sqlDecimalLength = rs.getInt(9);
                    aCol.sqlNotNull = "NO".equals(rs.getString(18));
                    aCol.hibernateType = JDBCUtil.getHibernateType(aCol.sqlType, aCol.sqlColumnLength, aCol.sqlDecimalLength);
                    aCol.javaType = JDBCUtil.getJavaType(aCol.sqlType, aCol.sqlColumnLength, aCol.sqlDecimalLength);
                    columns.add(aCol);
                }
                linkedList = columns;
                Object var9_10 = null;
                if (rs == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var9_11 = null;
                    if (rs == null) break block4;
                    rs.close();
                }
                throw throwable;
            }
            rs.close();
        }
        return linkedList;
    }

    public static NullableType getHibernateType(int sqlType, int columnSize, int decimalDigits) {
        logger.debug((Object)("sqlType=" + sqlType));
        logger.debug((Object)("columnSize=" + columnSize));
        logger.debug((Object)("decimalDigits=" + decimalDigits));
        NullableType rv = Hibernate.SERIALIZABLE;
        if (sqlType == 1 || sqlType == 12) {
            rv = Hibernate.STRING;
        } else if (sqlType == 6 || sqlType == 7) {
            rv = Hibernate.FLOAT;
        } else if (sqlType == 4) {
            rv = Hibernate.INTEGER;
        } else if (sqlType == 8) {
            rv = Hibernate.DOUBLE;
        } else if (sqlType == 91) {
            rv = Hibernate.DATE;
        } else if (sqlType == 93) {
            rv = Hibernate.TIMESTAMP;
        } else if (sqlType == 92) {
            rv = Hibernate.TIME;
        } else if (sqlType == 5) {
            rv = Hibernate.SHORT;
        } else if (sqlType == -7) {
            rv = Hibernate.BYTE;
        } else if (sqlType == -5) {
            rv = Hibernate.LONG;
        } else if (sqlType == 2 || sqlType == 3) {
            rv = decimalDigits == 0 ? (columnSize == 1 ? Hibernate.BYTE : (columnSize < 5 ? Hibernate.SHORT : (columnSize < 10 ? Hibernate.INTEGER : Hibernate.LONG))) : (columnSize < 9 ? Hibernate.FLOAT : Hibernate.DOUBLE);
        }
        return rv;
    }

    public static Class getJavaType(int sqlType, int columnSize, int decimalDigits) {
        logger.debug((Object)("sqlType=" + sqlType));
        logger.debug((Object)("columnSize=" + columnSize));
        logger.debug((Object)("decimalDigits=" + decimalDigits));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> rv = clazz;
        if (sqlType == 1 || sqlType == 12) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rv = clazz2;
        } else if (sqlType == 6 || sqlType == 7) {
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rv = clazz3;
        } else if (sqlType == 4) {
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rv = clazz4;
        } else if (sqlType == 8) {
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rv = clazz5;
        } else if (sqlType == 91) {
            Class<?> clazz6 = class$5;
            if (clazz6 == null) {
                try {
                    clazz6 = class$5 = Class.forName("java.util.Date");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rv = clazz6;
        } else if (sqlType == 93) {
            Class<?> clazz7 = class$5;
            if (clazz7 == null) {
                try {
                    clazz7 = class$5 = Class.forName("java.util.Date");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rv = clazz7;
        } else if (sqlType == 92) {
            Class<?> clazz8 = class$5;
            if (clazz8 == null) {
                try {
                    clazz8 = class$5 = Class.forName("java.util.Date");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rv = clazz8;
        } else if (sqlType == 5) {
            Class<?> clazz9 = class$6;
            if (clazz9 == null) {
                try {
                    clazz9 = class$6 = Class.forName("java.lang.Short");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rv = clazz9;
        } else if (sqlType == -7) {
            Class<?> clazz10 = class$7;
            if (clazz10 == null) {
                try {
                    clazz10 = class$7 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rv = clazz10;
        } else if (sqlType == -5) {
            Class<?> clazz11 = class$8;
            if (clazz11 == null) {
                try {
                    clazz11 = class$8 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            rv = clazz11;
        } else if (sqlType == 2 || sqlType == 3) {
            if (decimalDigits == 0) {
                if (columnSize == 1) {
                    Class<?> clazz12 = class$7;
                    if (clazz12 == null) {
                        try {
                            clazz12 = class$7 = Class.forName("java.lang.Byte");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    rv = clazz12;
                } else if (columnSize < 5) {
                    Class<?> clazz13 = class$6;
                    if (clazz13 == null) {
                        try {
                            clazz13 = class$6 = Class.forName("java.lang.Short");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    rv = clazz13;
                } else if (columnSize < 10) {
                    Class<?> clazz14 = class$3;
                    if (clazz14 == null) {
                        try {
                            clazz14 = class$3 = Class.forName("java.lang.Integer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    rv = clazz14;
                } else {
                    Class<?> clazz15 = class$8;
                    if (clazz15 == null) {
                        try {
                            clazz15 = class$8 = Class.forName("java.lang.Long");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    rv = clazz15;
                }
            } else if (columnSize < 9) {
                Class<?> clazz16 = class$2;
                if (clazz16 == null) {
                    try {
                        clazz16 = class$2 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                rv = clazz16;
            } else {
                Class<?> clazz17 = class$4;
                if (clazz17 == null) {
                    try {
                        clazz17 = class$4 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                rv = clazz17;
            }
        }
        return rv;
    }

    public static class Column {
        public String name;
        public int sqlType;
        public int sqlColumnLength;
        public int sqlDecimalLength;
        public boolean sqlNotNull;
        public boolean sqlReadOnly;
        public NullableType hibernateType;
        public Class javaType;

        public boolean equals(Object o) {
            boolean rv = false;
            if (o != null && o instanceof Column) {
                rv = this.name.equals(((Column)o).name);
            }
            return rv;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }
}

