/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sqlpanel;

import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import net.sourceforge.sqlexplorer.sqlpanel.SqlRowElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class SQLTableSorter
extends ViewerSorter {
    int count;
    public static final int ASCENDING = 1;
    public static final int DEFAULT_DIRECTION = 0;
    public static final int DESCENDING = -1;
    ResultSetMetaData metaData;
    protected int[] priorities;
    protected int[] directions;
    protected int[] DEFAULT_DIRECTIONS;
    protected int[] DEFAULT_PRIORITIES;
    protected int[] SQLType;

    public SQLTableSorter(int count, ResultSetMetaData metaData) {
        this.count = count;
        this.metaData = metaData;
        this.priorities = new int[count];
        this.directions = new int[count];
        this.DEFAULT_DIRECTIONS = new int[count];
        this.DEFAULT_PRIORITIES = new int[count];
        this.SQLType = new int[count];
        int i = 0;
        while (i < count) {
            this.DEFAULT_DIRECTIONS[i] = 1;
            this.DEFAULT_PRIORITIES[i] = i;
            try {
                this.SQLType[i] = metaData.getColumnType(i + 1);
            }
            catch (Throwable throwable) {
                this.SQLType[i] = 12;
            }
            ++i;
        }
        this.resetState();
    }

    public void setTopPriority(int priority) {
        if (priority < 0 || priority >= this.priorities.length) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.priorities.length) {
            if (this.priorities[i] == priority) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            this.resetState();
            return;
        }
        i = index;
        while (i > 0) {
            this.priorities[i] = this.priorities[i - 1];
            --i;
        }
        this.priorities[0] = priority;
        this.directions[priority] = this.DEFAULT_DIRECTIONS[priority];
    }

    public void resetState() {
        this.priorities = this.DEFAULT_PRIORITIES;
        this.directions = this.DEFAULT_DIRECTIONS;
    }

    public int reverseTopPriority() {
        int n = this.priorities[0];
        this.directions[n] = this.directions[n] * -1;
        return this.directions[this.priorities[0]];
    }

    public int getTopPriority() {
        return this.priorities[0];
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.compareColumnValue((SqlRowElement)e1, (SqlRowElement)e2, 0);
    }

    private int compareColumnValue(SqlRowElement m1, SqlRowElement m2, int depth) {
        if (depth >= this.priorities.length) {
            return 0;
        }
        int columnNumber = this.priorities[depth];
        int direction = this.directions[columnNumber];
        int result = 0;
        String v1 = m1.getValue(columnNumber).toString();
        String v2 = m2.getValue(columnNumber).toString();
        switch (this.SQLType[columnNumber]) {
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                result = this.collator.compare(m1.getValue(columnNumber), m2.getValue(columnNumber));
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                double d1 = 0.0;
                double d2 = 0.0;
                try {
                    d1 = Double.parseDouble(v1);
                }
                catch (Exception exception) {}
                try {
                    d2 = Double.parseDouble(v2);
                }
                catch (Exception exception) {}
                if (d1 == d2) {
                    result = 0;
                    break;
                }
                if (d1 > d2) {
                    result = 1;
                    break;
                }
                result = -1;
                break;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                v1 = m1.getValue(columnNumber).toString();
                v2 = m2.getValue(columnNumber).toString();
                long l1 = 0L;
                long l2 = 0L;
                try {
                    l1 = Long.parseLong(v1);
                }
                catch (Exception exception) {}
                try {
                    l2 = Long.parseLong(v2);
                }
                catch (Exception exception) {}
                if (l1 == l2) {
                    result = 0;
                    break;
                }
                if (l1 > l2) {
                    result = 1;
                    break;
                }
                result = -1;
                break;
            }
            case 91: {
                try {
                    Date dt1 = (Date)m1.getInternalValue(columnNumber);
                    Date dt2 = (Date)m2.getInternalValue(columnNumber);
                    if (dt1 == null && dt2 == null) {
                        result = 0;
                    }
                    if (dt2 == null) {
                        result = 1;
                        break;
                    }
                    if (dt1 == null) {
                        result = -1;
                        break;
                    }
                    result = dt1.compareTo(dt2);
                }
                catch (Exception exception) {}
                break;
            }
            case 93: {
                try {
                    Timestamp t1 = (Timestamp)m1.getInternalValue(columnNumber);
                    Timestamp t2 = (Timestamp)m2.getInternalValue(columnNumber);
                    if (t1 == null && t2 == null) {
                        result = 0;
                    }
                    if (t2 == null) {
                        result = 1;
                        break;
                    }
                    if (t1 == null) {
                        result = -1;
                        break;
                    }
                    result = t1.compareTo(t2);
                }
                catch (Exception exception) {}
                break;
            }
            case 92: {
                try {
                    Time t11 = (Time)m1.getInternalValue(columnNumber);
                    Time t22 = (Time)m2.getInternalValue(columnNumber);
                    if (t11 == null && t22 == null) {
                        result = 0;
                    }
                    if (t22 == null) {
                        result = 1;
                        break;
                    }
                    if (t11 == null) {
                        result = -1;
                        break;
                    }
                    result = t11.compareTo(t22);
                    break;
                }
                catch (Exception exception) {}
            }
        }
        if (result == 0) {
            return this.compareColumnValue(m1, m2, depth + 1);
        }
        return result * direction;
    }
}

