/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sessiontree.model.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.DoublyLinkedList;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.TernarySearchTree;
import net.sourceforge.sqlexplorer.sqleditor.SQLCodeScanner;

public class Dictionary {
    private static TernarySearchTree keywordsTree = new TernarySearchTree();
    private TernarySearchTree tree = new TernarySearchTree();
    private TernarySearchTree catalogSchemaTree = new TernarySearchTree();
    private TernarySearchTree externalObjectTree = new TernarySearchTree();
    private HashMap realTables = new HashMap();
    private HashMap realCatalogSchemas = new HashMap();
    private HashMap realExternalObjects = new HashMap();
    private HashMap col_map = new HashMap();

    static {
        String[] str = SQLCodeScanner.getFgKeywords();
        int i = 0;
        while (i < str.length) {
            keywordsTree.put(str[i], str[i]);
            ++i;
        }
    }

    public void putTableName(String key, Object value) {
        this.tree.put(key.toLowerCase(), value);
        this.realTables.put(key.toLowerCase(), key);
    }

    public void putCatalogSchemaName(String key, Object value) {
        this.catalogSchemaTree.put(key.toLowerCase(), value);
        this.realCatalogSchemas.put(key.toLowerCase(), key);
    }

    public void putExternalObjectName(String key, Object value) {
        this.externalObjectTree.put(key.toLowerCase(), value);
        this.realExternalObjects.put(key.toLowerCase(), key);
    }

    public Object getByTableName(String key) {
        return this.tree.get(key);
    }

    public Object getByCatalogSchemaName(String key) {
        return this.catalogSchemaTree.get(key);
    }

    public Object getByExternalObjectName(String key) {
        return this.catalogSchemaTree.get(key);
    }

    public void putColumnsByTableName(String key, Object value) {
        this.col_map.put(key, value);
    }

    public Object getColumnListByTableName(String key) {
        return this.col_map.get(key);
    }

    public Iterator getTableNames() {
        return this.realTables.keySet().iterator();
    }

    public Iterator getCatalogSchemaNames() {
        return this.realCatalogSchemas.keySet().iterator();
    }

    public Iterator getExternalObjectNames() {
        return this.realExternalObjects.keySet().iterator();
    }

    public ArrayList getTableObjectList(String tableName) {
        return (ArrayList)this.tree.get(tableName.toLowerCase());
    }

    public String[] matchTablePrefix(String prefix) {
        prefix = prefix.toLowerCase();
        DoublyLinkedList linkedList = this.tree.matchPrefix(prefix);
        int size = linkedList.size();
        DoublyLinkedList.DLLIterator iterator = linkedList.iterator();
        String[] result = new String[size];
        int k = 0;
        while (iterator.hasNext()) {
            result[k++] = (String)this.realTables.get(iterator.next());
        }
        return result;
    }

    public String[] matchCatalogSchemaPrefix(String prefix) {
        prefix = prefix.toLowerCase();
        DoublyLinkedList linkedList = this.catalogSchemaTree.matchPrefix(prefix);
        int size = linkedList.size();
        DoublyLinkedList.DLLIterator iterator = linkedList.iterator();
        String[] result = new String[size];
        int k = 0;
        while (iterator.hasNext()) {
            result[k++] = (String)this.realCatalogSchemas.get(iterator.next());
        }
        return result;
    }

    public String[] matchExternalObjectPrefix(String prefix) {
        prefix = prefix.toLowerCase();
        DoublyLinkedList linkedList = this.externalObjectTree.matchPrefix(prefix);
        int size = linkedList.size();
        DoublyLinkedList.DLLIterator iterator = linkedList.iterator();
        String[] result = new String[size];
        int k = 0;
        while (iterator.hasNext()) {
            result[k++] = (String)this.realExternalObjects.get(iterator.next());
        }
        return result;
    }

    public static String[] matchKeywordsPrefix(String prefix) {
        prefix = prefix.toLowerCase();
        DoublyLinkedList linkedList = keywordsTree.matchPrefix(prefix);
        int size = linkedList.size();
        DoublyLinkedList.DLLIterator iterator = linkedList.iterator();
        String[] result = new String[size];
        int k = 0;
        while (iterator.hasNext()) {
            result[k++] = (String)iterator.next();
        }
        return result;
    }
}

