/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sessiontree.model;

import java.sql.SQLException;
import java.util.ArrayList;
import net.sourceforge.sqlexplorer.IdentifierFactory;
import net.sourceforge.sqlexplorer.dbviewer.model.CatalogNode;
import net.sourceforge.sqlexplorer.dbviewer.model.DatabaseModel;
import net.sourceforge.sqlexplorer.dbviewer.model.DatabaseNode;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.SchemaNode;
import net.sourceforge.sqlexplorer.ext.PluginManager;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.ISessionTreeClosedListener;
import net.sourceforge.sqlexplorer.sessiontree.model.ISessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.RootSessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeModel;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.widgets.Table;

public class SessionTreeNode
implements ISessionTreeNode {
    private ListenerList listeners = new ListenerList();
    public DatabaseModel dbModel;
    private RootSessionTreeNode parent;
    private SQLConnection m_conn;
    private ISQLAlias alias;
    private SessionTreeModel model;
    private ArrayList ls = new ArrayList(10);
    PluginManager pm = null;
    private IIdentifier _id = IdentifierFactory.getInstance().createIdentifier();
    private Dictionary dictionary = new Dictionary();
    Table table;
    private final String pswd;
    boolean assistanceEnabled;

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public IIdentifier getIdentifier() {
        return this._id;
    }

    public SQLConnection getConnection() {
        return this.m_conn;
    }

    public Object[] getChildren() {
        return this.ls.toArray();
    }

    public Object getParent() {
        return this.parent;
    }

    public SQLConnection getSQLConnection() {
        return this.m_conn;
    }

    public String getCurrentConnectionPassword() {
        return this.pswd;
    }

    public boolean supportsCatalogs() {
        return this.dbModel.supportsCatalogs();
    }

    public String[] getCatalogs() {
        return this.dbModel.getCatalogNames();
    }

    public String getCatalog() {
        String cat = "";
        try {
            cat = this.m_conn.getCatalog();
        }
        catch (Throwable throwable) {}
        return cat;
    }

    public void setCatalog(String cat) throws SQLException {
        this.m_conn.getConnection().setCatalog(cat);
    }

    public SessionTreeNode(SQLConnection conn, ISQLAlias alias, SessionTreeModel md, IProgressMonitor monitor, String pswd) throws InterruptedException {
        this.m_conn = conn;
        this.alias = alias;
        this.pm = SQLExplorerPlugin.getDefault().pluginManager;
        this.pm.sessionStarted(this);
        this.dbModel = new DatabaseModel(this, this.pm);
        this.model = md;
        this.parent = md.getRoot();
        this.parent.add(this);
        this.pswd = pswd;
        this.assistanceEnabled = SQLExplorerPlugin.getDefault().getPreferenceStore().getBoolean("assist");
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException("Operation was cancelled by user");
        }
        try {
            Object[] children = this.dbModel.getChildren();
            DatabaseNode dbNode = (DatabaseNode)children[0];
            children = dbNode.getChildren();
            if (children == null) {
                return;
            }
            int i = 0;
            while (i < children.length) {
                if (monitor != null) {
                    monitor.subTask(children[i].toString());
                }
                if (monitor != null && monitor.isCanceled()) {
                    throw new InterruptedException("Operation was cancelled by user");
                }
                IDbModel idbModel = (IDbModel)children[i];
                this.dictionary.putCatalogSchemaName(idbModel.toString(), idbModel);
                if (this.assistanceEnabled) {
                    if (idbModel instanceof SchemaNode) {
                        ((SchemaNode)idbModel).fastLoadSchema();
                    } else if (idbModel instanceof CatalogNode) {
                        ((CatalogNode)idbModel).fastLoadCatalog();
                    }
                }
                ++i;
            }
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error enabling assistance ", e);
        }
    }

    public String toString() {
        try {
            return this.alias.getName();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting the alias name ", e);
            return "";
        }
    }

    public void add(ISessionTreeNode n) {
        this.ls.add(n);
    }

    public void remove(ISessionTreeNode n) {
        this.ls.remove(n);
    }

    public void close() {
        this.pm.sessionEnding(this);
        this.parent.remove(this);
        Object[] ls = this.listeners.getListeners();
        int i = 0;
        while (i < ls.length) {
            try {
                ((ISessionTreeClosedListener)ls[i]).sessionTreeClosed();
            }
            catch (Throwable throwable) {}
            ++i;
        }
        this.model.modelChanged(null);
        try {
            this.m_conn.close();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error closing database connection ", e);
        }
    }

    public void commit() {
        try {
            this.m_conn.commit();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error committing ", e);
        }
    }

    public void rollback() {
        try {
            this.m_conn.rollback();
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error rollbacking ", e);
        }
    }

    public PluginManager getPluginManager() {
        return this.pm;
    }

    public boolean isAutoCommitMode() {
        boolean result = false;
        try {
            result = this.m_conn.getAutoCommit();
        }
        catch (Throwable throwable) {}
        return result;
    }

    public void addListener(ISessionTreeClosedListener listener) {
        this.listeners.add((Object)listener);
    }

    public ISQLAlias getAlias() {
        return this.alias;
    }
}

