/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.sessiontree.actions;

import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.LoggingProgress;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.RetrievingTableDataProgress;
import net.sourceforge.sqlexplorer.dialogs.PasswordConnDlg;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class OpenPasswordConnectDialogAction
extends Action {
    Shell shell;
    ISQLAlias alias;
    DriverModel driverModel;
    IPreferenceStore store;
    SQLDriverManager dmgr;

    public OpenPasswordConnectDialogAction(Shell shell, ISQLAlias alias, DriverModel model, IPreferenceStore store, SQLDriverManager dmgr) {
        this.shell = shell;
        this.alias = alias;
        this.driverModel = model;
        this.store = store;
        this.dmgr = dmgr;
    }

    public void run() {
        PasswordConnDlg dlg = new PasswordConnDlg(this.shell, this.alias, this.driverModel, this.store);
        if (dlg.open() == 0) {
            String pswd = dlg.getPassword();
            String user = dlg.getUser();
            ISQLDriver dv = this.driverModel.getDriver(this.alias.getDriverIdentifier());
            try {
                LoggingProgress lp = new LoggingProgress(this.dmgr, dv, this.alias, user, pswd);
                ProgressMonitorDialog pg = new ProgressMonitorDialog(this.shell);
                pg.run(true, false, (IRunnableWithProgress)lp);
                if (lp.isOk()) {
                    SQLConnection conn = lp.getConn();
                    boolean autoCommit = dlg.getAutoCommit();
                    conn.setAutoCommit(autoCommit);
                    if (!autoCommit) {
                        conn.setCommitOnClose(dlg.getCommitOnClose());
                    }
                    RetrievingTableDataProgress rtdp = new RetrievingTableDataProgress(conn, this.alias, SQLExplorerPlugin.getDefault().stm, pswd);
                    ProgressMonitorDialog pg2 = new ProgressMonitorDialog(this.shell);
                    pg2.run(true, true, (IRunnableWithProgress)rtdp);
                } else {
                    MessageDialog.openError((Shell)this.shell, (String)Messages.getString("Error..._4"), (String)lp.getError());
                }
            }
            catch (Exception e) {
                SQLExplorerPlugin.error("Error Logging ", e);
            }
        }
    }
}

