/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.views;

import java.net.URL;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.plugin.views.CompositeSQLResultsViewer;
import net.sourceforge.sqlexplorer.sqlpanel.SQLTableSorter;
import net.sourceforge.sqlexplorer.sqlpanel.SqlTableLabelProvider;
import net.sourceforge.sqlexplorer.sqlpanel.SqlTableModel;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.part.ViewPart;

public class SqlResultsView
extends ViewPart {
    private String[][] ss;
    private int[] colCount;
    CompositeSQLResultsViewer[] cmp;
    SqlTableModel[] mo;
    SQLTableSorter[] sorter;
    Composite parent;
    TabFolder tabFolder;

    public void createPartControl(Composite parent) {
        this.parent = parent;
    }

    public void setFocus() {
    }

    public void setData(SqlTableModel[] new_mo) throws Exception {
        if (this.mo != null) {
            int i = 0;
            while (i < this.mo.length) {
                this.mo[i].closeResultSet();
                ++i;
            }
        }
        if (this.tabFolder == null) {
            this.tabFolder = new TabFolder(this.parent, 0);
        }
        this.mo = new_mo;
        this.sorter = new SQLTableSorter[this.mo.length];
        this.colCount = new int[this.mo.length];
        this.ss = new String[this.mo.length][];
        this.cmp = new CompositeSQLResultsViewer[this.mo.length];
        int tabItemNumber = this.tabFolder.getItemCount();
        int i = 0;
        while (i < new_mo.length) {
            this.sorter[i] = this.mo[i].sorter;
            this.colCount[i] = this.mo[i].ss.length;
            this.ss[i] = this.mo[i].ss;
            TabItem ti = new TabItem(this.tabFolder, 0);
            ti.setText("" + (tabItemNumber + i + 1));
            this.cmp[i] = new CompositeSQLResultsViewer(this, (Composite)this.tabFolder, 0, i, ti);
            ti.setControl((Control)this.cmp[i]);
            ++i;
        }
        this.refresh();
    }

    private void refresh() throws Exception {
        int jj = 0;
        while (jj < this.mo.length) {
            final int ii = jj;
            int count = this.colCount[ii];
            final Image imgAsc = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getAscOrderIcon()).createImage();
            final Image imgDesc = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getDescOrderIcon()).createImage();
            final TableViewer tableViewer = this.cmp[ii].getTableViewer();
            tableViewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    imgAsc.dispose();
                    imgDesc.dispose();
                }
            });
            final Table table = tableViewer.getTable();
            table.removeAll();
            if (this.mo == null) {
                return;
            }
            SelectionAdapter headerListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int column;
                    if (tableViewer.getSorter() == null) {
                        tableViewer.setSorter((ViewerSorter)SqlResultsView.this.sorter[ii]);
                    }
                    if ((column = table.indexOf((TableColumn)e.widget)) == SqlResultsView.this.sorter[ii].getTopPriority()) {
                        int k = SqlResultsView.this.sorter[ii].reverseTopPriority();
                        if (k == 1) {
                            ((TableColumn)e.widget).setImage(imgAsc);
                        } else {
                            ((TableColumn)e.widget).setImage(imgDesc);
                        }
                    } else {
                        SqlResultsView.this.sorter[ii].setTopPriority(column);
                        ((TableColumn)e.widget).setImage(imgAsc);
                    }
                    TableColumn[] tcArr = table.getColumns();
                    int i = 0;
                    while (i < tcArr.length) {
                        if (i != column) {
                            tcArr[i].setImage(null);
                        }
                        ++i;
                    }
                    tableViewer.refresh();
                    SqlResultsView.this.cmp[ii].setMessagePanel1("");
                }
            };
            int i = 0;
            while (i < count) {
                TableColumn tc = new TableColumn(table, 0);
                tc.setText(this.ss[ii][i]);
                tc.addSelectionListener((SelectionListener)headerListener);
                ++i;
            }
            tableViewer.setColumnProperties(this.ss[ii]);
            CellEditor[] cellEditors = new CellEditor[count];
            int i2 = 0;
            while (i2 < cellEditors.length) {
                final int colIndex = i2;
                cellEditors[i2] = new TextCellEditor((Composite)table){

                    protected void keyReleaseOccured(KeyEvent keyEvent) {
                        super.keyReleaseOccured(keyEvent);
                        int index = table.getSelectionIndex();
                        int newCol = colIndex;
                        TableItem[] selection = table.getSelection();
                        this.fireApplyEditorValue();
                        if (selection != null) {
                            table.setSelection(selection);
                        }
                        Object element = tableViewer.getElementAt(index);
                        tableViewer.reveal(element);
                        tableViewer.editElement(element, newCol);
                    }
                };
                ++i2;
            }
            tableViewer.setCellEditors(cellEditors);
            tableViewer.setLabelProvider((IBaseLabelProvider)new SqlTableLabelProvider(this.mo[ii]));
            tableViewer.setInput((Object)this.mo[ii]);
            tableViewer.refresh();
            tableViewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    SqlResultsView.this.mo[ii].closeResultSet();
                }
            });
            this.cmp[ii].setMessagePanel2(this.mo[ii].getPartial());
            tableViewer.getTable().addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    SqlResultsView.this.cmp[ii].setMessagePanel1(String.valueOf(Messages.getString("Selected_Row__1")) + (tableViewer.getTable().getSelectionIndex() + 1));
                }
            });
            this.cmp[ii].enableMoreRows(!this.mo[ii].isFinished());
            i2 = 0;
            while (i2 < count) {
                table.getColumn(i2).pack();
                ++i2;
            }
            table.layout();
            this.parent.layout();
            this.parent.redraw();
            ++jj;
        }
    }

    public SqlTableModel[] getModel() {
        return this.mo;
    }

    public TableViewer getTableViewer(int ii) {
        if (this.cmp == null) {
            return null;
        }
        return this.cmp[ii].getTableViewer();
    }

    public void enableMoreRows(int ii, boolean b) {
        this.cmp[ii].enableMoreRows(b);
    }

    public void setMessagePanel2(int ii, String string) {
        if (this.cmp != null) {
            this.cmp[ii].setMessagePanel2(string);
        }
    }
}

