/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.plugin.editors;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorInput;
import net.sourceforge.sqlexplorer.plugin.editors.SQLEditorSessionListener;
import net.sourceforge.sqlexplorer.plugin.views.DBView;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeModel;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.sqlexplorer.sessiontree.model.utility.Dictionary;
import net.sourceforge.sqlexplorer.sqlpanel.SQLTextViewer;
import net.sourceforge.sqlexplorer.sqlpanel.actions.ClearTextAction;
import net.sourceforge.sqlexplorer.sqlpanel.actions.ExecSQLAction;
import net.sourceforge.sqlexplorer.sqlpanel.actions.OpenFileAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;

public class SQLEditor
extends TextEditor {
    private MouseClickListener mcl = new MouseClickListener();
    private IPartListener partListener;
    IPreferenceStore store;
    public SQLTextViewer sqlTextViewer;
    ExecSQLAction execSQLAction;
    StatusLineManager statusMgr;
    SQLEditorSessionListener listener;
    private OpenFileAction openFileAction;
    private ClearTextAction clearTextAction;
    SessionTreeNode sessionTreeNode;
    Combo combo;
    Combo catalogCombo;
    SessionTreeModel stm;

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IContributionItem[] iContributionItems = SQLExplorerPlugin.getDefault().pluginManager.getEditorContextMenuActions(this);
        if (iContributionItems != null && iContributionItems.length > 0) {
            menu.add((IContributionItem)new Separator());
            int i = 0;
            while (i < iContributionItems.length) {
                menu.add(iContributionItems[i]);
                ++i;
            }
        }
    }

    public SQLEditor() {
        this.stm = SQLExplorerPlugin.getDefault().stm;
        this.store = SQLExplorerPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(this.store);
    }

    ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int style) {
        parent.setLayout((Layout)new FillLayout());
        Composite myParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        myParent.setLayout((Layout)layout);
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarMgr.createControl(myParent);
        GridData gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        gid.heightHint = 25;
        toolBar.setLayoutData((Object)gid);
        this.execSQLAction = new ExecSQLAction(this, this.store.getInt("maxSQLRows"));
        this.openFileAction = new OpenFileAction(this);
        this.clearTextAction = new ClearTextAction(this);
        toolBarMgr.add((IAction)this.execSQLAction);
        toolBarMgr.add((IAction)this.openFileAction);
        toolBarMgr.add((IAction)this.clearTextAction);
        IAction[] toolActions = SQLExplorerPlugin.getDefault().pluginManager.getEditorToolbarActions(this);
        if (toolActions != null) {
            int i = 0;
            while (i < toolActions.length) {
                toolBarMgr.add(toolActions[i]);
                ++i;
            }
        }
        toolBarMgr.update(true);
        ToolItem sep = new ToolItem(toolBar, 2);
        ToolItem sep2 = new ToolItem(toolBar, 2);
        this.combo = new Combo((Composite)toolBar, 8);
        this.catalogCombo = new Combo((Composite)toolBar, 8);
        this.listener = new SQLEditorSessionListener(this);
        this.stm.addListener(this.listener);
        this.buildCombo(this.stm);
        this.combo.setToolTipText("Choose Connection");
        this.combo.setSize(200, this.combo.getSize().y);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = SQLEditor.this.combo.getSelectionIndex();
                if (selIndex == 0) {
                    SQLEditor.this.execSQLAction.setEnabled(false);
                    SQLEditor.this.sessionTreeNode = null;
                    SQLEditor.this.catalogCombo.setVisible(false);
                } else {
                    SQLEditor.this.sessionTreeNode = SQLExplorerPlugin.getDefault().stm.getRoot().getSessionTreeNodes()[selIndex - 1];
                }
                if (SQLEditor.this.sessionTreeNode != null) {
                    SQLEditor.this.execSQLAction.setEnabled(true);
                    SQLEditor.this.setNewDictionary(SQLEditor.this.sessionTreeNode.getDictionary());
                    if (SQLEditor.this.sessionTreeNode.supportsCatalogs()) {
                        SQLEditor.this.catalogCombo.setVisible(true);
                        SQLEditor.this.catalogCombo.removeAll();
                        String[] catalogs = SQLEditor.this.sessionTreeNode.getCatalogs();
                        String currentCatalog = SQLEditor.this.sessionTreeNode.getCatalog();
                        int i = 0;
                        while (i < catalogs.length) {
                            SQLEditor.this.catalogCombo.add(catalogs[i]);
                            if (currentCatalog.equals(catalogs[i])) {
                                SQLEditor.this.catalogCombo.select(SQLEditor.this.catalogCombo.getItemCount() - 1);
                            }
                            ++i;
                        }
                    } else {
                        SQLEditor.this.catalogCombo.setVisible(false);
                    }
                } else {
                    SQLEditor.this.setNewDictionary(null);
                    SQLEditor.this.execSQLAction.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.catalogCombo.setToolTipText("Choose Catalog");
        this.catalogCombo.setSize(200, this.catalogCombo.getSize().y);
        this.catalogCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                int selIndex = SQLEditor.this.catalogCombo.getSelectionIndex();
                String newCat = SQLEditor.this.catalogCombo.getItem(selIndex);
                if (SQLEditor.this.sessionTreeNode != null) {
                    try {
                        SQLEditor.this.sessionTreeNode.setCatalog(newCat);
                    }
                    catch (Exception e1) {
                        SQLExplorerPlugin.error("Error changing catalog", e1);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        sep.setWidth(this.combo.getSize().x);
        sep.setControl((Control)this.combo);
        sep2.setWidth(this.catalogCombo.getSize().x);
        sep2.setControl((Control)this.catalogCombo);
        toolBar.pack();
        toolBar.update();
        gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        this.sqlTextViewer = new SQLTextViewer(myParent, style, this.store, null, ruler);
        this.sqlTextViewer.getControl().setLayoutData((Object)gid);
        this.sqlTextViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144 && event.keyCode == 13) {
                    event.doit = false;
                    SQLEditor.this.execSQLAction.run();
                }
            }
        });
        this.statusMgr = new StatusLineManager();
        this.statusMgr.createControl(myParent);
        gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        this.statusMgr.getControl().setLayoutData((Object)gid);
        myParent.layout();
        Document dc = new Document();
        this.sqlTextViewer.setDocument((IDocument)dc);
        if (this.sessionTreeNode != null) {
            this.setNewDictionary(this.sessionTreeNode.getDictionary());
        }
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part == SQLEditor.this && SQLEditor.this.sessionTreeNode != null && SQLEditor.this.sessionTreeNode.supportsCatalogs()) {
                    String catalog = SQLEditor.this.sessionTreeNode.getCatalog();
                    String[] catalogs = SQLEditor.this.catalogCombo.getItems();
                    int i = 0;
                    while (i < catalogs.length) {
                        if (catalog.equals(catalogs[i])) {
                            SQLEditor.this.catalogCombo.select(i);
                            break;
                        }
                        ++i;
                    }
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        this.getEditorSite().getPage().addPartListener(this.partListener);
        this.mcl.install((ISourceViewer)this.sqlTextViewer);
        return this.sqlTextViewer;
    }

    public void setNewDictionary(Dictionary dictionary) {
        if (this.sqlTextViewer != null) {
            this.sqlTextViewer.setNewDictionary(dictionary);
            this.sqlTextViewer.refresh();
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input instanceof SQLEditorInput) {
            SQLEditorInput sqlInput = (SQLEditorInput)input;
            this.sessionTreeNode = sqlInput.getSessionNode();
            if (this.sessionTreeNode != null) {
                this.setNewDictionary(this.sessionTreeNode.getDictionary());
            }
        }
    }

    public String getSQLToBeExecuted() {
        String sql = this.sqlTextViewer.getTextWidget().getSelectionText();
        if (sql == null || sql.trim().length() == 0) {
            sql = this.sqlTextViewer.getTextWidget().getText();
        }
        System.out.println("Exec " + sql);
        return sql != null ? sql : "";
    }

    public SessionTreeNode getSessionTreeNode() {
        return this.sessionTreeNode;
    }

    public void buildCombo(final SessionTreeModel stm) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    SQLEditor.this.combo.removeAll();
                    SQLEditor.this.catalogCombo.removeAll();
                    SessionTreeNode[] sessionNodes = stm.getRoot().getSessionTreeNodes();
                    SQLEditor.this.combo.add("");
                    boolean found = false;
                    int i = 0;
                    while (i < sessionNodes.length) {
                        SQLEditor.this.combo.add(sessionNodes[i].toString());
                        if (SQLEditor.this.sessionTreeNode == sessionNodes[i]) {
                            SQLEditor.this.combo.select(SQLEditor.this.combo.getItemCount() - 1);
                            found = true;
                        }
                        ++i;
                    }
                    if (!found) {
                        SQLEditor.this.sessionTreeNode = null;
                        SQLEditor.this.setNewDictionary(null);
                        SQLEditor.this.catalogCombo.setVisible(false);
                    }
                    if (found) {
                        if (SQLEditor.this.sessionTreeNode.supportsCatalogs()) {
                            SQLEditor.this.catalogCombo.setVisible(true);
                            String[] catalogs = SQLEditor.this.sessionTreeNode.getCatalogs();
                            String currentCatalog = SQLEditor.this.sessionTreeNode.getCatalog();
                            int i2 = 0;
                            while (i2 < catalogs.length) {
                                SQLEditor.this.catalogCombo.add(catalogs[i2]);
                                if (currentCatalog.equals(catalogs[i2])) {
                                    SQLEditor.this.catalogCombo.select(SQLEditor.this.catalogCombo.getItemCount() - 1);
                                }
                                ++i2;
                            }
                        } else {
                            SQLEditor.this.catalogCombo.setVisible(false);
                        }
                    }
                    SQLEditor.this.execSQLAction.setEnabled(found);
                }
                catch (Throwable throwable) {}
            }
        });
    }

    public void setText(String txt) {
        Document dc = new Document(txt);
        this.sqlTextViewer.setDocument((IDocument)dc);
        if (this.sessionTreeNode != null) {
            this.setNewDictionary(this.sessionTreeNode.getDictionary());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFile(String file) {
        FileReader fr = null;
        BufferedReader in = null;
        try {
            try {
                fr = new FileReader(file);
                in = new BufferedReader(fr);
                StringBuffer all = new StringBuffer();
                String delimiter = this.sqlTextViewer.getTextWidget().getLineDelimiter();
                while (true) {
                    String str;
                    if ((str = in.readLine()) == null) {
                        this.sqlTextViewer.setDocument((IDocument)new Document(all.toString()));
                    }
                    all.append(str);
                    all.append(delimiter);
                }
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Error loading document", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                fr.close();
            }
            catch (IOException iOException) {}
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        try {}
        catch (IOException iOException) {}
        fr.close();
        try {}
        catch (IOException iOException) {
            return;
        }
        in.close();
    }

    public void clearText() {
        this.sqlTextViewer.clearText();
    }

    public void dispose() {
        if (this.partListener != null) {
            this.getEditorSite().getPage().removePartListener(this.partListener);
        }
        this.stm.removeListener(this.listener);
        this.mcl.uninstall();
        super.dispose();
    }

    public void setMessage(String s) {
        this.statusMgr.setMessage(s);
    }

    protected void createActions() {
        super.createActions();
        Action action = new Action("Auto-Completion"){

            public void run() {
                SQLEditor.this.sqlTextViewer.showAssistance();
            }
        };
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.execSQLAction.setActionDefinitionId("net.sourceforge.sqlexplorer.sqlrun");
        this.setAction("SQL Run", (IAction)this.execSQLAction);
    }

    class MouseClickListener
    implements KeyListener,
    MouseListener,
    MouseMoveListener,
    FocusListener,
    PaintListener,
    IPropertyChangeListener,
    IDocumentListener,
    ITextInputListener {
        private boolean fActive;
        IDbModel activeTableNode;
        private ISourceViewer sourceViewer;
        private IRegion fActiveRegion;
        private Position fRememberedPosition;
        private Cursor fCursor;
        private Color fColor;
        private int fKeyModifierMask = 262144;

        MouseClickListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (this.fActive) {
                this.deactivate();
                return;
            }
            if (event.keyCode != this.fKeyModifierMask) {
                this.deactivate();
                return;
            }
            this.fActive = true;
        }

        public void deactivate() {
            this.deactivate(false);
        }

        public void deactivate(boolean redrawAll) {
            if (!this.fActive) {
                return;
            }
            this.repairRepresentation(redrawAll);
            this.fActive = false;
        }

        private void repairRepresentation(boolean redrawAll) {
            if (this.fActiveRegion == null) {
                return;
            }
            if (this.sourceViewer != null) {
                this.resetCursor(this.sourceViewer);
                int offset = this.fActiveRegion.getOffset();
                int length = this.fActiveRegion.getLength();
                if (!redrawAll && this.sourceViewer instanceof ITextViewerExtension2) {
                    ((ITextViewerExtension2)this.sourceViewer).invalidateTextPresentation(offset, length);
                } else {
                    this.sourceViewer.invalidateTextPresentation();
                }
                if (this.sourceViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)this.sourceViewer;
                    offset = extension.modelOffset2WidgetOffset(offset);
                } else {
                    offset -= this.sourceViewer.getVisibleRegion().getOffset();
                }
                StyledText text = this.sourceViewer.getTextWidget();
                try {
                    text.redrawRange(offset, length, true);
                }
                catch (IllegalArgumentException x) {
                    x.printStackTrace();
                }
            }
            this.fActiveRegion = null;
        }

        private void resetCursor(ISourceViewer viewer) {
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                text.setCursor(null);
            }
            if (this.fCursor != null) {
                this.fCursor.dispose();
                this.fCursor = null;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (!this.fActive) {
                return;
            }
            this.deactivate();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent event) {
            if (!this.fActive) {
                return;
            }
            if (event.stateMask != this.fKeyModifierMask) {
                this.deactivate();
                return;
            }
            if (event.button != 1) {
                this.deactivate();
                return;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (!this.fActive) {
                return;
            }
            if (e.button != 1) {
                this.deactivate();
                return;
            }
            boolean wasActive = this.fCursor != null;
            this.deactivate();
            if (wasActive) {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this){
                    final /* synthetic */ MouseClickListener this$1;
                    {
                        this.this$1 = mouseClickListener;
                    }

                    public void run() {
                        try {
                            DBView dbView = (DBView)MouseClickListener.access$0(this.this$1).getEditorSite().getWorkbenchWindow().getActivePage().findView("net.sourceforge.sqlexplorer.plugin.views.DBView");
                            if (dbView != null) {
                                MouseClickListener.access$0(this.this$1).getEditorSite().getWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)dbView);
                                dbView.setInput(MouseClickListener.access$0((MouseClickListener)this.this$1).sessionTreeNode);
                                dbView.tryToSelect(MouseClickListener.access$0((MouseClickListener)this.this$1).sessionTreeNode, this.this$1.activeTableNode);
                            }
                        }
                        catch (Exception e1) {
                            SQLExplorerPlugin.error("Error selecting table", e1);
                        }
                    }
                });
            }
        }

        public void mouseMove(MouseEvent event) {
            if (event.widget instanceof Control && !((Control)event.widget).isFocusControl()) {
                this.deactivate();
                return;
            }
            if (!this.fActive) {
                if (event.stateMask != this.fKeyModifierMask) {
                    return;
                }
                this.fActive = true;
            }
            if (this.sourceViewer == null) {
                this.deactivate();
                return;
            }
            StyledText text = this.sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                this.deactivate();
                return;
            }
            if ((event.stateMask & 0x80000) != 0 && text.getSelectionCount() != 0) {
                this.deactivate();
                return;
            }
            IRegion region = this.getCurrentTextRegion(this.sourceViewer);
            if (region == null || region.getLength() == 0) {
                this.repairRepresentation();
                return;
            }
            this.highlightRegion(this.sourceViewer, region);
            this.activateCursor(this.sourceViewer);
        }

        private void activateCursor(ISourceViewer viewer) {
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            Display display = text.getDisplay();
            if (this.fCursor == null) {
                this.fCursor = new Cursor((Device)display, 21);
            }
            text.setCursor(this.fCursor);
        }

        private void repairRepresentation() {
            this.repairRepresentation(false);
        }

        private IRegion selectWord(IDocument document, int anchor) {
            try {
                char c;
                int offset = anchor;
                while (offset >= 0) {
                    c = document.getChar(offset);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    --offset;
                }
                int start = offset;
                offset = anchor;
                int length = document.getLength();
                while (offset < length) {
                    c = document.getChar(offset);
                    if (!Character.isJavaIdentifierPart(c)) break;
                    ++offset;
                }
                int end = offset;
                if (start == end) {
                    return new Region(start, 0);
                }
                return new Region(start + 1, end - start - 1);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        private IRegion getCurrentTextRegion(ISourceViewer viewer) {
            if (viewer == null) {
                return null;
            }
            Dictionary dictionary = ((SQLTextViewer)viewer).dictionary;
            if (dictionary == null) {
                return null;
            }
            int offset = this.getCurrentTextOffset(viewer);
            if (offset == -1) {
                return null;
            }
            try {
                IRegion reg = this.selectWord(viewer.getDocument(), offset);
                if (reg == null) {
                    return null;
                }
                String selection = viewer.getDocument().get(reg.getOffset(), reg.getLength());
                if (selection == null) {
                    return null;
                }
                Object obj = dictionary.getByTableName(selection.toLowerCase());
                if (obj == null) {
                    return null;
                }
                if (!(obj instanceof ArrayList)) {
                    return null;
                }
                ArrayList ls = (ArrayList)obj;
                if (ls.isEmpty()) {
                    return null;
                }
                Object node = ((ArrayList)obj).get(0);
                if (!(node instanceof TableNode)) {
                    return null;
                }
                this.activeTableNode = (TableNode)node;
                return reg;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private int getCurrentTextOffset(ISourceViewer viewer) {
            try {
                StyledText text = viewer.getTextWidget();
                if (text == null || text.isDisposed()) {
                    return -1;
                }
                Display display = text.getDisplay();
                Point absolutePosition = display.getCursorLocation();
                Point relativePosition = text.toControl(absolutePosition);
                int widgetOffset = text.getOffsetAtLocation(relativePosition);
                if (viewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                    return extension.widgetOffset2ModelOffset(widgetOffset);
                }
                return widgetOffset + viewer.getVisibleRegion().getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }

        private void highlightRegion(ISourceViewer viewer, IRegion region) {
            if (region.equals(this.fActiveRegion)) {
                return;
            }
            this.repairRepresentation();
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            int offset = 0;
            int length = 0;
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                IRegion widgetRange = extension.modelRange2WidgetRange(region);
                if (widgetRange == null) {
                    return;
                }
                offset = widgetRange.getOffset();
                length = widgetRange.getLength();
            } else {
                offset = region.getOffset() - viewer.getVisibleRegion().getOffset();
                length = region.getLength();
            }
            StyleRange oldStyleRange = text.getStyleRangeAtOffset(offset);
            Color foregroundColor = this.fColor;
            Color backgroundColor = oldStyleRange == null ? text.getBackground() : oldStyleRange.background;
            StyleRange styleRange = new StyleRange(offset, length, foregroundColor, backgroundColor);
            text.setStyleRange(styleRange);
            text.redrawRange(offset, length, true);
            this.fActiveRegion = region;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.deactivate();
        }

        public void paintControl(PaintEvent event) {
            if (this.fActiveRegion == null) {
                return;
            }
            if (this.sourceViewer == null) {
                return;
            }
            StyledText text = this.sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            int offset = 0;
            int length = 0;
            if (this.sourceViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)this.sourceViewer;
                IRegion widgetRange = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
                if (widgetRange == null) {
                    return;
                }
                offset = widgetRange.getOffset();
                length = widgetRange.getLength();
            } else {
                IRegion region = this.sourceViewer.getVisibleRegion();
                if (!this.includes(region, this.fActiveRegion)) {
                    return;
                }
                offset = this.fActiveRegion.getOffset() - region.getOffset();
                length = this.fActiveRegion.getLength();
            }
            Point minLocation = this.getMinimumLocation(text, offset, length);
            Point maxLocation = this.getMaximumLocation(text, offset, length);
            int x1 = minLocation.x;
            int x2 = minLocation.x + maxLocation.x - minLocation.x - 1;
            int y = minLocation.y + text.getLineHeight() - 1;
            GC gc = event.gc;
            if (this.fColor != null && !this.fColor.isDisposed()) {
                gc.setForeground(this.fColor);
            }
            gc.drawLine(x1, y, x2, y);
        }

        private boolean includes(IRegion region, IRegion position) {
            return position.getOffset() >= region.getOffset() && position.getOffset() + position.getLength() <= region.getOffset() + region.getLength();
        }

        private Point getMinimumLocation(StyledText text, int offset, int length) {
            Point minLocation = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            int i = 0;
            while (i <= length) {
                Point location = text.getLocationAtOffset(offset + i);
                if (location.x < minLocation.x) {
                    minLocation.x = location.x;
                }
                if (location.y < minLocation.y) {
                    minLocation.y = location.y;
                }
                ++i;
            }
            return minLocation;
        }

        private Point getMaximumLocation(StyledText text, int offset, int length) {
            Point maxLocation = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
            int i = 0;
            while (i <= length) {
                Point location = text.getLocationAtOffset(offset + i);
                if (location.x > maxLocation.x) {
                    maxLocation.x = location.x;
                }
                if (location.y > maxLocation.y) {
                    maxLocation.y = location.y;
                }
                ++i;
            }
            return maxLocation;
        }

        public void propertyChange(PropertyChangeEvent event) {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (this.fActive && this.fActiveRegion != null) {
                this.fRememberedPosition = new Position(this.fActiveRegion.getOffset(), this.fActiveRegion.getLength());
                try {
                    event.getDocument().addPosition(this.fRememberedPosition);
                }
                catch (BadLocationException badLocationException) {
                    this.fRememberedPosition = null;
                }
            }
        }

        public void documentChanged(DocumentEvent event) {
            StyledText widget;
            if (this.fRememberedPosition != null && !this.fRememberedPosition.isDeleted()) {
                event.getDocument().removePosition(this.fRememberedPosition);
                this.fActiveRegion = new Region(this.fRememberedPosition.getOffset(), this.fRememberedPosition.getLength());
            }
            this.fRememberedPosition = null;
            if (this.sourceViewer != null && (widget = this.sourceViewer.getTextWidget()) != null && !widget.isDisposed()) {
                widget.getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ MouseClickListener this$1;
                    {
                        this.this$1 = mouseClickListener;
                    }

                    public void run() {
                        this.this$1.deactivate();
                    }
                });
            }
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            this.deactivate();
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }

        public void install(ISourceViewer sourceViewer) {
            this.sourceViewer = sourceViewer;
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            this.updateColor(sourceViewer);
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
            text.addKeyListener((KeyListener)this);
            text.addMouseListener((MouseListener)this);
            text.addMouseMoveListener((MouseMoveListener)this);
            text.addFocusListener((FocusListener)this);
            text.addPaintListener((PaintListener)this);
        }

        public void uninstall() {
            StyledText text;
            if (this.fColor != null) {
                this.fColor.dispose();
                this.fColor = null;
            }
            if (this.fCursor != null) {
                this.fCursor.dispose();
                this.fCursor = null;
            }
            if (this.sourceViewer == null) {
                return;
            }
            this.sourceViewer.removeTextInputListener((ITextInputListener)this);
            IDocument document = this.sourceViewer.getDocument();
            if (document != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
            if ((text = this.sourceViewer.getTextWidget()) == null || text.isDisposed()) {
                return;
            }
            text.removeKeyListener((KeyListener)this);
            text.removeMouseListener((MouseListener)this);
            text.removeMouseMoveListener((MouseMoveListener)this);
            text.removeFocusListener((FocusListener)this);
            text.removePaintListener((PaintListener)this);
        }

        private void updateColor(ISourceViewer viewer) {
            StyledText text;
            if (this.fColor != null) {
                this.fColor.dispose();
            }
            if ((text = viewer.getTextWidget()) == null || text.isDisposed()) {
                return;
            }
            Display display = text.getDisplay();
            this.fColor = new Color((Device)display, new RGB(0, 0, 255));
        }

        static /* synthetic */ SQLEditor access$0(MouseClickListener mouseClickListener) {
            return mouseClickListener.SQLEditor.this;
        }
    }
}

