/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode;
import net.sourceforge.sqlexplorer.gef.wizards.ReverseDatabaseWizard;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectTables
extends WizardPage {
    ReverseDatabaseWizard wizard;
    ListViewer lvLeft;
    ListViewer lvRight;
    ArrayList selectedList = new ArrayList();
    List selectedSchemas;

    protected SelectTables(String pageName, ReverseDatabaseWizard wizard) {
        super(pageName);
        this.setTitle(pageName);
        this.wizard = wizard;
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite1 = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite1.setLayout((Layout)layout);
        Label label = new Label(composite1, 0);
        label.setText("Tables");
        new Label(composite1, 0);
        Label label1 = new Label(composite1, 0);
        label1.setText("Tables selected for import");
        org.eclipse.swt.widgets.List ls = new org.eclipse.swt.widgets.List(composite1, 2818);
        ls.setLayoutData((Object)new GridData(1808));
        this.lvLeft = new ListViewer(ls);
        this.lvLeft.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] objs = ((List)inputElement).toArray();
                return objs;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.lvLeft.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TableNode) {
                    try {
                        return ((TableNode)element).getTableInfo().getQualifiedName();
                    }
                    catch (Exception exception) {}
                }
                return element == null ? "" : element.toString();
            }
        });
        Composite cmp2 = new Composite(composite1, 0);
        cmp2.setLayout((Layout)new GridLayout(1, true));
        final org.eclipse.swt.widgets.List ls2 = new org.eclipse.swt.widgets.List(composite1, 2818);
        ls2.setLayoutData((Object)new GridData(1808));
        this.lvRight = new ListViewer(ls2);
        this.lvRight.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.lvRight.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.lvRight.setInput((Object)this.selectedList);
        Button toRight = new Button(cmp2, 8);
        toRight.setText(">");
        toRight.setLayoutData((Object)new GridData(768));
        toRight.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)SelectTables.this.lvLeft.getSelection();
                Iterator it = sel.iterator();
                while (it.hasNext()) {
                    IDbModel table = (IDbModel)it.next();
                    if (SelectTables.this.selectedList.contains(table)) continue;
                    SelectTables.this.selectedList.add(table);
                }
                SelectTables.this.lvRight.refresh();
                if (ls2.getItemCount() > 0) {
                    SelectTables.this.setPageComplete(true);
                } else {
                    SelectTables.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toRight.setToolTipText("Move selected tables into right list");
        Button allToRight = new Button(cmp2, 8);
        allToRight.setText(">>");
        allToRight.setLayoutData((Object)new GridData(768));
        allToRight.setToolTipText("Move all tables into right list");
        allToRight.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectTables.this.selectedList.clear();
                List ls = (List)SelectTables.this.lvLeft.getInput();
                SelectTables.this.selectedList.addAll(ls);
                SelectTables.this.lvRight.refresh();
                if (ls2.getItemCount() > 0) {
                    SelectTables.this.setPageComplete(true);
                } else {
                    SelectTables.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button allToLeft = new Button(cmp2, 8);
        allToLeft.setText("<<");
        allToLeft.setLayoutData((Object)new GridData(768));
        allToLeft.setToolTipText("Remove all tables from right list");
        allToLeft.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectTables.this.selectedList.clear();
                SelectTables.this.lvRight.refresh();
                if (ls2.getItemCount() > 0) {
                    SelectTables.this.setPageComplete(true);
                } else {
                    SelectTables.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button toLeft = new Button(cmp2, 8);
        toLeft.setText("<");
        toLeft.setLayoutData((Object)new GridData(768));
        toLeft.setToolTipText("Remove selected tables from right list");
        toLeft.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)SelectTables.this.lvRight.getSelection();
                Iterator it = sel.iterator();
                while (it.hasNext()) {
                    IDbModel table = (IDbModel)it.next();
                    SelectTables.this.selectedList.remove(table);
                }
                SelectTables.this.lvRight.refresh();
                if (ls2.getItemCount() > 0) {
                    SelectTables.this.setPageComplete(true);
                } else {
                    SelectTables.this.setPageComplete(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        super.setControl((Control)composite1);
    }

    public void updateSelectedSchemas(List list) {
        this.selectedSchemas = list;
        this.selectedList.clear();
        this.lvRight.refresh();
        Iterator it = this.selectedSchemas.iterator();
        ArrayList<Object> tables = new ArrayList<Object>();
        while (it.hasNext()) {
            IDbModel parentNode = (IDbModel)it.next();
            Object[] children = parentNode.getChildren();
            int i = 0;
            while (i < children.length) {
                TableObjectTypeNode tableParent;
                IDbModel child = (IDbModel)children[i];
                if (child instanceof TableObjectTypeNode && (tableParent = (TableObjectTypeNode)child).toString().equalsIgnoreCase("TABLE")) {
                    tables.addAll(Arrays.asList(tableParent.getChildren()));
                }
                ++i;
            }
        }
        this.lvLeft.setInput(tables);
        this.lvLeft.refresh();
        this.setPageComplete(false);
    }
}

