/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.figures;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.sqlexplorer.gef.figures.ColumnContainerFigure;
import net.sourceforge.sqlexplorer.gef.figures.CompartmentFigureBorder;
import net.sourceforge.sqlexplorer.gef.model.Column;
import net.sourceforge.sqlexplorer.gef.model.Table;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class TableFigure
extends Figure {
    static Font tableLabelFont = new Font(null, "Arial", 10, 1);
    protected Hashtable connectionAnchors = new Hashtable(7);
    protected Vector inputConnectionAnchors = new Vector(2, 2);
    protected Vector outputConnectionAnchors = new Vector(2, 2);
    Label label;
    RectangleFigure rectFigure;
    public static CompartmentFigureBorder containerBorder = new CompartmentFigureBorder();
    public static Color classColor = ColorConstants.white;
    ColumnContainerFigure container;
    Table table;

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        return (ConnectionAnchor)this.connectionAnchors.get(terminal);
    }

    public String getConnectionAnchorName(ConnectionAnchor c) {
        Enumeration enumeration = this.connectionAnchors.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!this.connectionAnchors.get(key).equals(c)) continue;
            return key;
        }
        return null;
    }

    public TableFigure(Table table) {
        this.table = table;
        this.setToolTip((IFigure)new Label(table.getQualifiedName()));
        this.label = new Label(table.getQualifiedName());
        this.label.setFont(tableLabelFont);
        this.label.setBorder(this.border);
        ToolbarLayout layout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        this.setBackgroundColor(classColor);
        this.setOpaque(true);
        this.add((IFigure)this.label);
        this.container = new ColumnContainerFigure(table, table.isShowColumnDetail());
        this.container.setBorder((Border)containerBorder);
        this.add((IFigure)this.container);
        Column[] columns = table.getColumns();
        this.container.setColumns(columns);
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration e = this.getSourceConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            ConnectionAnchor c = (ConnectionAnchor)e.nextElement();
            Point p2 = c.getLocation(null);
            long d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public void setLabel(String string) {
        this.label.setText(string);
    }

    public void setColumnTypeVisible(boolean b) {
        this.container.setColumnTypeVisible(b);
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration e = this.getTargetConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            ConnectionAnchor c = (ConnectionAnchor)e.nextElement();
            Point p2 = c.getLocation(null);
            long d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public Vector getTargetConnectionAnchors() {
        return this.inputConnectionAnchors;
    }

    public Vector getSourceConnectionAnchors() {
        return this.outputConnectionAnchors;
    }
}

