/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.figures;

import java.net.URL;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.gef.figures.ColumnFigure;
import net.sourceforge.sqlexplorer.gef.model.Column;
import net.sourceforge.sqlexplorer.gef.model.Table;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

class ColumnContainerFigure
extends Figure {
    static Font columnLabelFont = new Font(null, "Arial", 8, 1);
    static Font columnTypeFont = new Font(null, "Arial", 8, 0);
    static Image keyImage = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getKeyIcon()).createImage();
    static Image nullImage = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getNullIcon()).createImage();
    ColumnFigure left = new ColumnFigure();
    ColumnFigure right = new ColumnFigure();
    Table table;

    public ColumnContainerFigure(Table table, boolean showColumnTypes) {
        this.table = table;
        ToolbarLayout layout = new ToolbarLayout(true);
        layout.setSpacing(5);
        this.setLayoutManager((LayoutManager)layout);
        layout.setStretchMinorAxis(false);
        this.add((IFigure)this.left);
        this.left.setFont(columnLabelFont);
        this.right.setVisible(showColumnTypes);
        this.add((IFigure)this.right);
        this.right.setFont(columnTypeFont);
    }

    public void setColumnTypeVisible(boolean b) {
        this.right.setVisible(b);
    }

    public void setColumns(Column[] columns) {
        int i = 0;
        while (i < columns.length) {
            Label leftLabel = new Label(columns[i].columnName);
            if (this.table.isPrimaryKey(columns[i])) {
                leftLabel.setIcon(keyImage);
            } else {
                leftLabel.setIcon(nullImage);
            }
            this.left.add((IFigure)leftLabel);
            Label rightLabel = new Label(columns[i].typeNameExtended);
            rightLabel.setIcon(nullImage);
            this.right.add((IFigure)rightLabel);
            ++i;
        }
    }
}

