/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.editors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.gef.editors.LogicTreeContainerEditPolicy;
import net.sourceforge.sqlexplorer.gef.model.Schema;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SchemaTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener {
    static Image image = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getSchemaIcon()).createImage();

    public SchemaTreeEditPart(Object model) {
        super(model);
    }

    public void activate() {
        super.activate();
        this.getLogicSubpart().addPropertyChangeListener(this);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("TreeContainerEditPolicy", (EditPolicy)new LogicTreeContainerEditPolicy());
        if (this.getParent() instanceof RootEditPart) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        }
    }

    public void deactivate() {
        this.getLogicSubpart().removePropertyChangeListener(this);
        super.deactivate();
    }

    protected Schema getLogicSubpart() {
        return (Schema)this.getModel();
    }

    protected List getModelChildren() {
        return Arrays.asList(this.getLogicSubpart().getElements());
    }

    public void propertyChange(PropertyChangeEvent change) {
        this.refreshVisuals();
        this.refreshChildren();
    }

    protected void refreshVisuals() {
        if (this.getWidget() instanceof Tree) {
            return;
        }
        TreeItem item = (TreeItem)this.getWidget();
        if (image != null) {
            image.setBackground(item.getParent().getBackground());
        }
        this.setWidgetImage(image);
        this.setWidgetText(this.getLogicSubpart().toString());
    }
}

