/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.commands;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.gef.model.AbstractModelObject;
import net.sourceforge.sqlexplorer.gef.model.Schema;
import net.sourceforge.sqlexplorer.gef.model.Table;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class CreateObjectModelCommand
extends Command {
    private AbstractModelObject obj;
    private Rectangle rect;
    private Schema schema;

    public Schema getSchema() {
        return this.schema;
    }

    public void redo() {
        this.execute();
    }

    public void setLocation(Rectangle rectangle) {
        this.rect = rectangle;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public AbstractModelObject getNamedObject() {
        return this.obj;
    }

    public void setNamedObject(AbstractModelObject table) {
        this.obj = table;
    }

    public void execute() {
        Point point = new Point(this.rect.x, this.rect.y);
        this.obj.setLocation(point);
        this.rect.isEmpty();
        Dimension dimension = new Dimension(this.rect.width, this.rect.height);
        this.obj.setSize(dimension);
        if (this.obj instanceof Table) {
            Table target = (Table)this.obj;
            target.createLinks(this.schema);
        }
        this.schema.addChild(this.obj);
    }

    public void undo() {
        this.schema.removeChild(this.obj);
        if (this.obj instanceof Table) {
            Table target = (Table)this.obj;
            target.removeLinks(this.schema);
        }
    }

    public String getLabel() {
        return String.valueOf(Messages.getString("CreateObjectModelCommand.Create_object__1")) + this.obj;
    }
}

