/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.gef.commands;

import java.util.ArrayList;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.gef.model.Schema;
import net.sourceforge.sqlexplorer.gef.model.Table;
import net.sourceforge.sqlexplorer.gef.wizards.TableAdapter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

public class AddTablesToSchemaCommand
extends Command {
    Schema schema;
    ArrayList tableList = new ArrayList();

    public AddTablesToSchemaCommand(Schema schema, ArrayList tableAdapterList) {
        this.schema = schema;
        int i = 0;
        while (i < tableAdapterList.size()) {
            TableAdapter tadapt = (TableAdapter)tableAdapterList.get(i);
            Table tb = tadapt.adapt();
            tb.setLocation(new Point(10 + i * 40, 10 + i * 40));
            tb.setSize(new Dimension(-1, -1));
            this.tableList.add(tb);
            ++i;
        }
    }

    public AddTablesToSchemaCommand(String label) {
        super(label);
    }

    public void redo() {
        this.execute();
    }

    public void execute() {
        int i = 0;
        while (i < this.tableList.size()) {
            Table tb = (Table)this.tableList.get(i);
            tb.createLinks(this.schema);
            this.schema.addChild(tb);
            ++i;
        }
    }

    public void undo() {
        int i = 0;
        while (i < this.tableList.size()) {
            Table tb = (Table)this.tableList.get(i);
            tb.removeLinks(this.schema);
            this.schema.removeChild((Table)this.tableList.get(i));
            ++i;
        }
    }

    public String getLabel() {
        return Messages.getString("AddTablesToSchemaCommand.Add_tables_to_current_schema_visualizer_1");
    }
}

