/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dialogs;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class DriverLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private HashMap imageCache = new HashMap(11);
    ImageDescriptor okDescriptor = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getOkDriver());
    ImageDescriptor errDescriptor = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getErrorDriver());

    DriverLabelProvider() {
    }

    public Image getColumnImage(Object element, int i) {
        ISQLDriver dv = (ISQLDriver)element;
        ImageDescriptor descriptor = null;
        descriptor = dv.isJDBCDriverClassLoaded() ? this.okDescriptor : this.errDescriptor;
        Image image = (Image)this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public String getColumnText(Object element, int i) {
        ISQLDriver dv = (ISQLDriver)element;
        return dv.getName();
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void dispose() {
        Iterator i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
        this.imageCache.clear();
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void addListener(ILabelProviderListener listener) {
    }
}

