/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dialogs;

import java.net.URL;
import net.sourceforge.sqlexplorer.AliasModel;
import net.sourceforge.sqlexplorer.DriverModel;
import net.sourceforge.sqlexplorer.IdentifierFactory;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dialogs.AliasContentProvider;
import net.sourceforge.sqlexplorer.dialogs.AliasLabelProvider;
import net.sourceforge.sqlexplorer.dialogs.CreateAliasDlg;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.actions.OpenPasswordConnectDialogAction;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;

public class AliasContainerGroup
extends Composite {
    Action changeAlias;
    Action copyAlias;
    Action newAlias;
    Action deleteAlias;
    TableViewer tableViewer;
    AliasModel model;
    DriverModel driverModel;

    void selectFirst() {
        if (this.model.getElements().length > 0) {
            Object obj = this.model.getElements()[0];
            StructuredSelection sel = new StructuredSelection(obj);
            this.tableViewer.setSelection((ISelection)sel);
        }
    }

    private void createActions() {
        this.newAlias = new Action(){
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getAliasWizard());

            public String getToolTipText() {
                return Messages.getString("CreateAlias");
            }

            public String getText() {
                return Messages.getString("CreateAlias");
            }

            public ImageDescriptor getHoverImageDescriptor() {
                return this.img;
            }

            public ImageDescriptor getImageDescriptor() {
                return this.img;
            }

            public void run() {
                IdentifierFactory factory = IdentifierFactory.getInstance();
                ISQLAlias alias = AliasContainerGroup.this.model.createAlias(factory.createIdentifier());
                CreateAliasDlg dlg = new CreateAliasDlg(AliasContainerGroup.this.getShell(), AliasContainerGroup.this.driverModel, 1, alias, AliasContainerGroup.this.model);
                dlg.open();
                AliasContainerGroup.this.tableViewer.refresh();
                AliasContainerGroup.this.selectFirst();
            }
        };
        this.changeAlias = new Action(){
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getEditAlias());

            public String getText() {
                return Messages.getString("ChangeAlias");
            }

            public String getToolTipText() {
                return Messages.getString("ChangeAlias");
            }

            public ImageDescriptor getHoverImageDescriptor() {
                return this.img;
            }

            public ImageDescriptor getImageDescriptor() {
                return this.img;
            }

            public void run() {
                StructuredSelection sel = (StructuredSelection)AliasContainerGroup.this.tableViewer.getSelection();
                ISQLAlias al = (ISQLAlias)sel.getFirstElement();
                if (al != null) {
                    CreateAliasDlg dlg = new CreateAliasDlg(AliasContainerGroup.this.getShell(), AliasContainerGroup.this.driverModel, 2, al, AliasContainerGroup.this.model);
                    dlg.open();
                    AliasContainerGroup.this.tableViewer.refresh();
                    AliasContainerGroup.this.selectFirst();
                }
            }
        };
        this.copyAlias = new Action(){
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getCopyAlias());

            public String getToolTipText() {
                return Messages.getString("CopyAlias");
            }

            public String getText() {
                return Messages.getString("CopyAlias");
            }

            public ImageDescriptor getHoverImageDescriptor() {
                return this.img;
            }

            public ImageDescriptor getImageDescriptor() {
                return this.img;
            }

            public void run() {
                StructuredSelection sel = (StructuredSelection)AliasContainerGroup.this.tableViewer.getSelection();
                ISQLAlias al = (ISQLAlias)sel.getFirstElement();
                IdentifierFactory factory = IdentifierFactory.getInstance();
                ISQLAlias alias = AliasContainerGroup.this.model.createAlias(factory.createIdentifier());
                if (al != null) {
                    try {
                        alias.assignFrom(al);
                    }
                    catch (ValidationException validationException) {}
                    CreateAliasDlg dlg = new CreateAliasDlg(AliasContainerGroup.this.getShell(), AliasContainerGroup.this.driverModel, 3, alias, AliasContainerGroup.this.model);
                    dlg.open();
                    int i = 0;
                    while (i < AliasContainerGroup.this.model.getElements().length) {
                        ++i;
                    }
                    AliasContainerGroup.this.tableViewer.refresh();
                    AliasContainerGroup.this.selectFirst();
                }
            }
        };
        this.deleteAlias = new Action(){
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getDeleteAlias());

            public String getToolTipText() {
                return Messages.getString("DeleteAlias");
            }

            public ImageDescriptor getHoverImageDescriptor() {
                return this.img;
            }

            public ImageDescriptor getImageDescriptor() {
                return this.img;
            }

            public void run() {
                StructuredSelection sel = (StructuredSelection)AliasContainerGroup.this.tableViewer.getSelection();
                ISQLAlias al = (ISQLAlias)sel.getFirstElement();
                if (al != null) {
                    AliasContainerGroup.this.model.removeAlias(al);
                    AliasContainerGroup.this.tableViewer.refresh();
                    AliasContainerGroup.this.selectFirst();
                }
            }
        };
    }

    public AliasContainerGroup(Composite parent, AliasModel m, DriverModel dm) {
        super(parent, 0);
        this.model = m;
        this.driverModel = dm;
        this.setLayout((Layout)new FillLayout());
        Composite myParent = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        myParent.setLayout((Layout)layout);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        ToolBarManager toolBarMgr = new ToolBarManager(0x800000);
        this.createActions();
        toolBarMgr.add((IAction)this.newAlias);
        toolBarMgr.add((IAction)this.changeAlias);
        toolBarMgr.add((IAction)this.copyAlias);
        toolBarMgr.add((IAction)this.deleteAlias);
        toolBarMgr.createControl(myParent);
        GridData gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        toolBarMgr.getControl().setLayoutData((Object)gid);
        gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        this.tableViewer = new TableViewer(myParent, 772);
        this.tableViewer.getControl().setLayoutData((Object)gid);
        this.tableViewer.setContentProvider((IContentProvider)new AliasContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AliasLabelProvider());
        this.tableViewer.setInput((Object)this.model);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ISQLAlias al = (ISQLAlias)selection.getFirstElement();
                    OpenPasswordConnectDialogAction openDlgAction = new OpenPasswordConnectDialogAction(AliasContainerGroup.this.tableViewer.getTable().getShell(), al, AliasContainerGroup.this.driverModel, SQLExplorerPlugin.getDefault().getPreferenceStore(), SQLExplorerPlugin.getDefault().getSQLDriverManager());
                    openDlgAction.run();
                }
            }
        });
        this.selectFirst();
        final Table table = this.tableViewer.getTable();
        MenuManager menuMgr = new MenuManager("#AliasMenu");
        menuMgr.setRemoveAllWhenShown(false);
        menuMgr.add((IAction)new Action(){

            public String getText() {
                return "Open...";
            }

            public void run() {
                ISQLAlias al = (ISQLAlias)((IStructuredSelection)AliasContainerGroup.this.tableViewer.getSelection()).getFirstElement();
                OpenPasswordConnectDialogAction openDlgAction = new OpenPasswordConnectDialogAction(table.getShell(), al, AliasContainerGroup.this.driverModel, SQLExplorerPlugin.getDefault().getPreferenceStore(), SQLExplorerPlugin.getDefault().getSQLDriverManager());
                openDlgAction.run();
            }
        });
        menuMgr.add((IAction)this.newAlias);
        menuMgr.add((IAction)this.changeAlias);
        menuMgr.add((IAction)this.copyAlias);
        Menu aliasContextMenu = menuMgr.createContextMenu((Control)table);
        this.tableViewer.getTable().setMenu(aliasContextMenu);
        myParent.layout();
        parent.layout();
    }

    public ISQLAlias getSelection() {
        ISQLAlias al = (ISQLAlias)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        return al;
    }
}

