/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbviewer.DetailManager;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode;
import net.sourceforge.sqlexplorer.ext.PluginManager;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import org.eclipse.swt.widgets.Composite;

public class CatalogNode
implements IDbModel {
    private IDbModel parent;
    private String txt;
    private PluginManager pm;
    private ArrayList list = new ArrayList(10);
    private boolean loaded = false;
    private SessionTreeNode sessionNode;
    String[] tbTypes = null;
    private volatile int hash = 0;

    public Composite getComposite(DetailManager detailManager) {
        return null;
    }

    public CatalogNode(IDbModel s, String name, SessionTreeNode sessionNode, PluginManager pm) {
        this.sessionNode = sessionNode;
        this.parent = s;
        this.txt = name;
        this.pm = pm;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CatalogNode)) {
            return false;
        }
        CatalogNode cn = (CatalogNode)obj;
        return cn.txt == this.txt;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int result = 17;
            if (this.txt != null) {
                result = 37 * result + this.txt.hashCode();
            }
            this.hash = result;
        }
        return this.hash;
    }

    public void refresh() {
        this.list.clear();
        this.load();
    }

    private void load() {
        try {
            this.tbTypes = this.sessionNode.getConnection().getSQLMetaData().getTableTypes();
            int i = 0;
            while (i < this.tbTypes.length) {
                String tableType = this.tbTypes[i];
                this.add(new TableObjectTypeNode(this, tableType, this.sessionNode.getConnection()));
                ++i;
            }
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error getting catalog children", e);
        }
        try {
            IDbModel[] added = this.pm.getCatalogAddedTypes(this, this.sessionNode);
            if (added != null) {
                int i = 0;
                while (i < added.length) {
                    IDbModel added_ = added[i];
                    this.add(added_);
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            SQLExplorerPlugin.error("Error Retrieving schema children in plugin ", e);
        }
    }

    public Object[] getChildren() {
        if (!this.loaded) {
            this.load();
            this.loaded = true;
        }
        return this.list.toArray();
    }

    private void add(IDbModel m) {
        this.list.add(m);
    }

    public String toString() {
        return this.txt;
    }

    public SessionTreeNode getSessionNode() {
        return this.sessionNode;
    }

    public void fastLoadCatalog() {
        if (!this.loaded) {
            this.load();
            this.loaded = true;
        }
        try {
            String ctg;
            if (this.tbTypes == null) {
                this.tbTypes = this.sessionNode.getConnection().getSQLMetaData().getTableTypes();
            }
            if ((ctg = this.txt).equals(Messages.getString("NoCatalog_2"))) {
                ctg = null;
            }
            ITableInfo[] tables = this.sessionNode.getConnection().getSQLMetaData().getTables(ctg, null, "%", this.tbTypes);
            HashMap<String, ArrayList<TableNode>> mp = new HashMap<String, ArrayList<TableNode>>();
            if (tables == null) {
                return;
            }
            int i = 0;
            while (i < tables.length) {
                String type = tables[i].getType();
                ArrayList<TableNode> listTables = (ArrayList<TableNode>)mp.get(type);
                if (listTables == null) {
                    listTables = new ArrayList<TableNode>(100);
                    mp.put(type, listTables);
                }
                listTables.add(new TableNode(null, tables[i].getSimpleName(), this.sessionNode.getConnection(), tables[i]));
                ++i;
            }
            i = 0;
            int sz = this.list.size();
            while (i < sz) {
                IDbModel dbModel = (IDbModel)this.list.get(i);
                if (dbModel instanceof TableObjectTypeNode) {
                    TableObjectTypeNode tp = (TableObjectTypeNode)dbModel;
                    ArrayList ls = (ArrayList)mp.get(tp.toString());
                    if (ls != null) {
                        tp.setTables(ls);
                    } else {
                        tp.setTables(new ArrayList(0));
                    }
                }
                ++i;
            }
        }
        catch (SQLException e) {
            SQLExplorerPlugin.error("Error Retrieving schema children in plugin ", e);
        }
    }
}

