/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.details;

import java.sql.ResultSet;
import java.sql.Statement;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbviewer.actions.CopyTableAction;
import net.sourceforge.sqlexplorer.dbviewer.details.IDetailLogDisplay;
import net.sourceforge.sqlexplorer.dbviewer.details.PKDetailContentProvider;
import net.sourceforge.sqlexplorer.dbviewer.details.PKDetailLabelProvider;
import net.sourceforge.sqlexplorer.dbviewer.details.PKDetailTableModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PKDetail
implements IDetailLogDisplay {
    TableTreeViewer viewer;
    TableNode node;
    boolean activated = false;
    IDetailLogDisplay detailLog;
    String errorMessage;

    public PKDetail(TabItem itemTab, Composite parent, IDetailLogDisplay detailLog) {
        this.detailLog = detailLog;
        this.viewer = new TableTreeViewer(parent, 67584);
        itemTab.setControl(this.viewer.getControl());
        TableTree tableTree = this.viewer.getTableTree();
        Table table = tableTree.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        MenuManager menuMgr = new MenuManager("#TableMenu");
        menuMgr.setRemoveAllWhenShown(false);
        menuMgr.add((IAction)new CopyTableAction(table));
        Menu fDbContextMenu = menuMgr.createContextMenu((Control)table);
        table.setMenu(fDbContextMenu);
        TableColumn tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Primary_Key_1"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Order_2"));
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < 2) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50, true));
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        this.viewer.setContentProvider((IContentProvider)new PKDetailContentProvider());
    }

    public void setNode(TableNode node) {
        this.node = node;
        this.activated = false;
    }

    public void setMessage(String s) {
        this.errorMessage = s;
        this.detailLog.setMessage(s);
    }

    public void activate() {
        if (!this.activated) {
            Display display = this.viewer.getControl().getDisplay();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                public void run() {
                    ResultSet rs = null;
                    try {
                        rs = PKDetail.this.node.getPK();
                    }
                    catch (Throwable e) {
                        SQLExplorerPlugin.error("Error activating PK view ", e);
                        PKDetail.this.errorMessage = e.getMessage();
                        PKDetail.this.detailLog.setMessage(PKDetail.this.errorMessage);
                    }
                    PKDetailTableModel idtm = new PKDetailTableModel(rs, PKDetail.this);
                    PKDetailLabelProvider idlp = new PKDetailLabelProvider(idtm);
                    PKDetail.this.viewer.setLabelProvider((IBaseLabelProvider)idlp);
                    PKDetail.this.viewer.setInput((Object)idtm);
                    PKDetail.this.viewer.refresh();
                    PKDetail.this.activated = true;
                    try {
                        Statement st = rs.getStatement();
                        if (st != null) {
                            st.close();
                        }
                        rs.close();
                    }
                    catch (Throwable throwable) {}
                }
            });
        } else {
            this.detailLog.setMessage(this.errorMessage);
        }
    }
}

