/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.details;

import java.sql.ResultSet;
import java.sql.Statement;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbviewer.actions.CopyTableAction;
import net.sourceforge.sqlexplorer.dbviewer.details.IDetailLogDisplay;
import net.sourceforge.sqlexplorer.dbviewer.details.IndexDetailContentProvider;
import net.sourceforge.sqlexplorer.dbviewer.details.IndexDetailLabelProvider;
import net.sourceforge.sqlexplorer.dbviewer.details.IndexDetailTableModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class IndexDetail
implements IDetailLogDisplay {
    TableTreeViewer viewer;
    TableNode node;
    boolean activated = false;
    IDetailLogDisplay detailLog;
    String errorMessage = "";

    public void setMessage(String s) {
        this.detailLog.setMessage(s);
        this.errorMessage = s;
    }

    public IndexDetail(TabItem itemTab, Composite parent, IDetailLogDisplay detailLog) {
        this.detailLog = detailLog;
        this.viewer = new TableTreeViewer(parent, 67584);
        itemTab.setControl(this.viewer.getControl());
        TableTree tableTree = this.viewer.getTableTree();
        Table table = tableTree.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        MenuManager menuMgr = new MenuManager("#TableMenu");
        menuMgr.setRemoveAllWhenShown(false);
        menuMgr.add((IAction)new CopyTableAction(table));
        Menu fDbContextMenu = menuMgr.createContextMenu((Control)table);
        table.setMenu(fDbContextMenu);
        TableColumn tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Index_Name_2"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Unique_3"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Type_4"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Order_5"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Asc_or_Desc_6"));
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < 5) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50, true));
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        this.viewer.setContentProvider((IContentProvider)new IndexDetailContentProvider());
    }

    public void setNode(TableNode node) {
        this.node = node;
        this.activated = false;
    }

    public void activate() {
        if (!this.activated) {
            Display display = this.viewer.getControl().getDisplay();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                public void run() {
                    ResultSet rs = null;
                    try {
                        rs = IndexDetail.this.node.getIndexes();
                    }
                    catch (Exception e) {
                        SQLExplorerPlugin.error("Error activating index detail view ", e);
                        IndexDetail.this.errorMessage = e.getMessage();
                        IndexDetail.this.detailLog.setMessage(IndexDetail.this.errorMessage);
                    }
                    IndexDetailTableModel idtm = new IndexDetailTableModel(rs, IndexDetail.this);
                    IndexDetailLabelProvider idlp = new IndexDetailLabelProvider(idtm);
                    IndexDetail.this.viewer.setLabelProvider((IBaseLabelProvider)idlp);
                    IndexDetail.this.viewer.setInput((Object)idtm);
                    IndexDetail.this.viewer.refresh();
                    IndexDetail.this.activated = true;
                    try {
                        Statement st = rs.getStatement();
                        if (st != null) {
                            st.close();
                        }
                        rs.close();
                    }
                    catch (Throwable throwable) {}
                }
            });
        } else {
            this.detailLog.setMessage(this.errorMessage);
        }
    }
}

