/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.details;

import java.sql.ResultSet;
import java.sql.Statement;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbviewer.actions.CopyTableAction;
import net.sourceforge.sqlexplorer.dbviewer.details.FKDetailContentProvider;
import net.sourceforge.sqlexplorer.dbviewer.details.FKDetailLabelProvider;
import net.sourceforge.sqlexplorer.dbviewer.details.FKDetailTableModel;
import net.sourceforge.sqlexplorer.dbviewer.details.IDetailLogDisplay;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class FKDetail
implements IDetailLogDisplay {
    TableTreeViewer viewer;
    TableNode node;
    boolean activated = false;
    IDetailLogDisplay detailLog;
    String errorMessage;

    public FKDetail(TabItem itemTab, Composite parent, IDetailLogDisplay detailLog) {
        this.detailLog = detailLog;
        this.viewer = new TableTreeViewer(parent, 67584);
        itemTab.setControl(this.viewer.getControl());
        TableTree tableTree = this.viewer.getTableTree();
        Table table = tableTree.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        MenuManager menuMgr = new MenuManager("#TableMenu");
        menuMgr.setRemoveAllWhenShown(false);
        menuMgr.add((IAction)new CopyTableAction(table));
        Menu fDbContextMenu = menuMgr.createContextMenu((Control)table);
        table.setMenu(fDbContextMenu);
        TableColumn tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Foreign_Key_1"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Order_2"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("SQL_Table_1"));
        tc = new TableColumn(table, 0);
        tc.setText(Messages.getString("Primary_Key_1"));
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < 4) {
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 25, true));
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        this.viewer.setContentProvider((IContentProvider)new FKDetailContentProvider());
    }

    public void setNode(TableNode node) {
        this.node = node;
        this.activated = false;
    }

    public void setMessage(String s) {
        this.errorMessage = s;
        this.detailLog.setMessage(s);
    }

    public void activate() {
        if (!this.activated) {
            Display display = this.viewer.getControl().getDisplay();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                public void run() {
                    ResultSet rs = null;
                    try {
                        rs = FKDetail.this.node.getFK();
                    }
                    catch (Throwable e) {
                        SQLExplorerPlugin.error("Error activating FK view ", e);
                        FKDetail.this.errorMessage = e.getMessage();
                        FKDetail.this.detailLog.setMessage(FKDetail.this.errorMessage);
                    }
                    FKDetailTableModel idtm = new FKDetailTableModel(rs, FKDetail.this);
                    FKDetailLabelProvider idlp = new FKDetailLabelProvider(idtm);
                    FKDetail.this.viewer.setLabelProvider((IBaseLabelProvider)idlp);
                    FKDetail.this.viewer.setInput((Object)idtm);
                    FKDetail.this.viewer.refresh();
                    FKDetail.this.activated = true;
                    try {
                        Statement st = rs.getStatement();
                        if (st != null) {
                            st.close();
                        }
                        rs.close();
                    }
                    catch (Throwable throwable) {}
                }
            });
        } else {
            this.detailLog.setMessage(this.errorMessage);
        }
    }
}

