/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.actions.editdialog;

import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbviewer.actions.editdialog.EditorDialog;
import net.sourceforge.sqlexplorer.dbviewer.actions.editdialog.SQLTableContentProvider;
import net.sourceforge.sqlexplorer.dbviewer.actions.editdialog.TableCellModifier;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SQLComposite
extends Composite {
    TableViewer tableViewer;
    StatusLineManager statusMgr;
    EditorDialog editDialog;
    Composite tableComposite;

    public StatusLineManager getStatusLineManager() {
        return this.statusMgr;
    }

    private void createTableViewer(Composite myParent) {
        myParent.setLayout((Layout)new FillLayout());
        this.tableViewer = new TableViewer(myParent, 66304);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent evt) {
                SQLComposite.this.handleDoubleClick(evt);
            }
        });
        this.tableViewer.setCellModifier((ICellModifier)new TableCellModifier(this.editDialog));
        this.tableViewer.setContentProvider((IContentProvider)new SQLTableContentProvider());
        this.tableViewer.setUseHashlookup(true);
    }

    public SQLComposite(Composite parent, int style, final EditorDialog editDialog) {
        super(parent, style);
        this.editDialog = editDialog;
        this.setLayout((Layout)new FillLayout());
        Composite myParent = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        myParent.setLayout((Layout)layout);
        Composite cmpTextEditor = new Composite(myParent, 0);
        cmpTextEditor.setLayout((Layout)new GridLayout(3, false));
        Label lbWhere = new Label(cmpTextEditor, 0);
        lbWhere.setText(Messages.getString("SQLComposite.Write_your_where_condition__1"));
        final Text txt = new Text(cmpTextEditor, 2048);
        GridData txtGridData = new GridData(768);
        txt.setLayoutData((Object)txtGridData);
        Button btn = new Button(cmpTextEditor, 8);
        btn.setText(Messages.getString("SQLComposite.Apply_2"));
        editDialog.getShell().setDefaultButton(btn);
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                editDialog.updateWhereCondition(txt.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        cmpTextEditor.setLayoutData((Object)gid);
        this.tableComposite = new Composite(myParent, 0);
        gid = new GridData();
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        this.tableComposite.setLayoutData((Object)gid);
        this.createTableViewer(this.tableComposite);
        this.statusMgr = new StatusLineManager();
        this.statusMgr.createControl(myParent);
        new Label((Composite)this.statusMgr.getControl(), 0);
        gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        this.statusMgr.getControl().setLayoutData((Object)gid);
        myParent.layout();
    }

    protected void handleDoubleClick(MouseEvent evt) {
        Table t = (Table)evt.widget;
        int index = t.getSelectionIndex();
        if (index != -1) {
            int i = 0;
            while (i < t.getColumnCount()) {
                if (t.getItem(index).getBounds(i).contains(evt.x, evt.y)) {
                    try {
                        this.tableViewer.editElement(this.tableViewer.getElementAt(index), i);
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                ++i;
            }
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }
}

