/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.actions;

import java.util.List;
import net.sourceforge.sqlexplorer.dbviewer.actions.CopyName;
import net.sourceforge.sqlexplorer.dbviewer.actions.ExportTableScript;
import net.sourceforge.sqlexplorer.dbviewer.actions.Refresh;
import net.sourceforge.sqlexplorer.dbviewer.actions.RefreshCatalog;
import net.sourceforge.sqlexplorer.dbviewer.actions.RefreshSchema;
import net.sourceforge.sqlexplorer.dbviewer.actions.RefreshTable;
import net.sourceforge.sqlexplorer.dbviewer.actions.SelectAll;
import net.sourceforge.sqlexplorer.dbviewer.actions.TableDirectEdit;
import net.sourceforge.sqlexplorer.dbviewer.actions.TableObjectTypeRefresh;
import net.sourceforge.sqlexplorer.dbviewer.model.CatalogNode;
import net.sourceforge.sqlexplorer.dbviewer.model.DatabaseNode;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.SchemaNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode;
import net.sourceforge.sqlexplorer.ext.PluginManager;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.plugin.views.DBView;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.actions.ActionGroup;

public class DatabaseActionGroup
extends ActionGroup {
    IAction selectAll;
    IAction tableScript;
    IAction refresh;
    TreeViewer tv;
    PluginManager pluginManager;
    List extensionsActions;
    DBView view;

    public void fillContextMenu(IMenuManager menu) {
        Action refresh1;
        IDbModel nd = this.getDbNode();
        if (nd == null) {
            return;
        }
        SessionTreeNode node = this.view.getSessionTreeNode();
        if (node == null) {
            return;
        }
        if (nd instanceof TableNode) {
            TableNode tn = (TableNode)nd;
            this.selectAll = new SelectAll(node, tn);
            menu.add(this.selectAll);
            if (tn.isTable()) {
                TableDirectEdit tableEdit = new TableDirectEdit(node, tn);
                menu.add((IAction)tableEdit);
                RefreshTable refreshTable = new RefreshTable(this.view, node, tn);
                menu.add((IAction)refreshTable);
            }
            this.tableScript = new ExportTableScript(node, tn);
            menu.add(this.tableScript);
            try {
                IAction[] obj = this.pluginManager.getAddedActions(node, this.getDbNode(), this.tv);
                if (obj != null) {
                    int i = 0;
                    while (i < obj.length) {
                        menu.add(obj[i]);
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {}
        } else if (nd instanceof SchemaNode) {
            SchemaNode schema = (SchemaNode)nd;
            refresh1 = new RefreshSchema(schema, this.tv);
            menu.add((IAction)refresh1);
        } else if (nd instanceof CatalogNode) {
            CatalogNode cat = (CatalogNode)nd;
            refresh1 = new RefreshCatalog(cat, this.tv);
            menu.add((IAction)refresh1);
        } else if (nd instanceof TableObjectTypeNode) {
            TableObjectTypeNode totn = (TableObjectTypeNode)nd;
            refresh1 = new TableObjectTypeRefresh(totn, this.tv);
            menu.add((IAction)refresh1);
            try {
                IAction[] obj = this.pluginManager.getAddedActions(node, this.getDbNode(), this.tv);
                if (obj != null) {
                    int i = 0;
                    while (i < obj.length) {
                        menu.add(obj[i]);
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {}
        } else if (nd instanceof DatabaseNode) {
            this.refresh = new Refresh(this.view);
            menu.add(this.refresh);
        }
        if (!(nd instanceof TableObjectTypeNode) && !(nd instanceof DatabaseNode)) {
            menu.add((IAction)new CopyName(nd));
        }
        try {
            IAction[] obj = this.pluginManager.getTypeActions(node, this.getDbNode(), this.tv);
            if (obj != null) {
                int i = 0;
                while (i < obj.length) {
                    menu.add(obj[i]);
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {}
    }

    public DatabaseActionGroup(DBView view, TreeViewer tv) {
        this.pluginManager = SQLExplorerPlugin.getDefault().pluginManager;
        this.view = view;
        this.tv = tv;
    }

    public IDbModel getDbNode() {
        ISelection sel = this.tv.getSelection();
        IStructuredSelection iSel = (IStructuredSelection)sel;
        return (IDbModel)iSel.getFirstElement();
    }
}

