/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer.actions;

import java.net.URL;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CopyTableAction
extends Action {
    Clipboard cb;
    private ImageDescriptor img = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getExportToClipBoardIcon());
    Table tb;

    public CopyTableAction(Table tb) {
        this.tb = tb;
        this.cb = new Clipboard(tb.getDisplay());
    }

    public ImageDescriptor getImageDescriptor() {
        return this.img;
    }

    public String getText() {
        return Messages.getString("CopyTableAction.Copy_to_Clipboard_1");
    }

    public void run() {
        try {
            final IPreferenceStore store = SQLExplorerPlugin.getDefault().getPreferenceStore();
            BusyIndicator.showWhile((Display)this.tb.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        String exp_sep = store.getString("clip_export_separator");
                        boolean exp_columns = store.getBoolean("clip_export_columns");
                        StringBuffer buf = new StringBuffer();
                        String separator = System.getProperty("line.separator");
                        TableColumn[] colNames = CopyTableAction.this.tb.getColumns();
                        if (exp_columns) {
                            int i = 0;
                            while (i < colNames.length) {
                                buf.append(colNames[i].getText());
                                buf.append(exp_sep);
                                ++i;
                            }
                            buf.append(separator);
                        }
                        int length = CopyTableAction.this.tb.getItemCount();
                        int i = 0;
                        while (i < length) {
                            TableItem row = CopyTableAction.this.tb.getItem(i);
                            int j = 0;
                            while (j < colNames.length) {
                                buf.append(row.getText(j));
                                buf.append(exp_sep);
                                ++j;
                            }
                            buf.append(separator);
                            ++i;
                        }
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        CopyTableAction.this.cb.setContents(new Object[]{buf.toString()}, new Transfer[]{textTransfer});
                    }
                    catch (Exception e) {
                        SQLExplorerPlugin.error("Error exporting to clipboard ", e);
                    }
                }
            });
        }
        catch (Exception e) {
            SQLExplorerPlugin.error("Error exporting to clipboard ", e);
        }
    }
}

