/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer;

import java.util.ArrayList;
import net.sourceforge.sqlexplorer.Messages;
import net.sourceforge.sqlexplorer.dbviewer.details.ColumnsDetail;
import net.sourceforge.sqlexplorer.dbviewer.details.FKDetail;
import net.sourceforge.sqlexplorer.dbviewer.details.IDetailLogDisplay;
import net.sourceforge.sqlexplorer.dbviewer.details.IndexDetail;
import net.sourceforge.sqlexplorer.dbviewer.details.PKDetail;
import net.sourceforge.sqlexplorer.dbviewer.details.PreviewDetail;
import net.sourceforge.sqlexplorer.dbviewer.details.RowCountDetail;
import net.sourceforge.sqlexplorer.dbviewer.details.StatusLineLogDisplay;
import net.sourceforge.sqlexplorer.dbviewer.model.IDbModel;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode;
import net.sourceforge.sqlexplorer.ext.IActivablePanel;
import net.sourceforge.sqlexplorer.plugin.SQLExplorerPlugin;
import net.sourceforge.sqlexplorer.sessiontree.model.SessionTreeNode;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class DetailManager {
    private Composite parent;
    private Composite overParent;
    private Composite overTableObjectTypeParent;
    private Composite tableNodeComposite;
    private StackLayout sLayout = new StackLayout();
    ColumnsDetail colDetail;
    IndexDetail indDetail;
    PKDetail pkDetail;
    FKDetail fkDetail;
    PreviewDetail previewDetail;
    RowCountDetail rowCountDetail;
    TabFolder tabFolder;
    private StatusLineManager slm;
    IDetailLogDisplay detailLog;
    private IPreferenceStore store;
    private SessionTreeNode sessionTreeNode;
    private TreeViewer tv;
    ArrayList addedTabs = new ArrayList();
    IActivablePanel[] panels = null;
    private Composite extComposite;
    private Text objectCountTextWidget;

    public DetailManager(TreeViewer tv, Composite c, IPreferenceStore store, SessionTreeNode sessionTreeNode) {
        this.parent = new Composite(c, 0);
        this.tv = tv;
        this.store = store;
        this.parent.setLayout((Layout)this.sLayout);
        this.sessionTreeNode = sessionTreeNode;
    }

    public Composite getComposite() {
        return this.parent;
    }

    public void activate(IDbModel m) {
        if (this.extComposite != null) {
            try {
                this.extComposite.dispose();
                this.extComposite = null;
            }
            catch (Throwable throwable) {}
        }
        this.panels = null;
        if (!this.addedTabs.isEmpty()) {
            int i = 0;
            while (i < this.addedTabs.size()) {
                ((TabItem)this.addedTabs.get(i)).dispose();
                ++i;
            }
            this.addedTabs.clear();
        }
        if (m instanceof TableNode) {
            if (this.tableNodeComposite == null) {
                this.createTableNodeComposite();
            }
            TableNode tn = (TableNode)m;
            this.panels = SQLExplorerPlugin.getDefault().pluginManager.getAddedPanels(this.sessionTreeNode, tn);
            if (this.panels != null && this.panels.length > 0) {
                int i = 0;
                while (i < this.panels.length) {
                    TabItem itemTab = new TabItem(this.tabFolder, 0);
                    itemTab.setText(this.panels[i].getText());
                    itemTab.setControl(this.panels[i].create(this.sessionTreeNode, tn, (Composite)this.tabFolder));
                    this.addedTabs.add(itemTab);
                    ++i;
                }
            }
            this.colDetail.setNode(tn);
            this.indDetail.setNode(tn);
            this.pkDetail.setNode(tn);
            this.fkDetail.setNode(tn);
            this.previewDetail.setNode(tn);
            this.rowCountDetail.setNode(tn);
            int sel = this.tabFolder.getSelectionIndex();
            if (sel == 0) {
                this.colDetail.activate();
            } else if (sel == 1) {
                this.indDetail.activate();
            } else if (sel == 2) {
                this.pkDetail.activate();
            } else if (sel == 3) {
                this.fkDetail.activate();
            } else if (sel == 4) {
                this.previewDetail.activate();
            } else if (sel == 5) {
                this.rowCountDetail.activate();
            } else {
                try {
                    this.panels[sel - 6].activate();
                }
                catch (Throwable e) {
                    SQLExplorerPlugin.error("error activating plugin ", e);
                }
            }
            this.sLayout.topControl = this.overParent;
        } else if (m instanceof TableObjectTypeNode) {
            if (this.objectCountTextWidget == null) {
                this.createTableObjectTypeComposite();
            }
            Object[] obj = ((TableObjectTypeNode)m).getChildren();
            int count = 0;
            if (obj != null) {
                count = obj.length;
            }
            this.objectCountTextWidget.setText("" + count);
            this.sLayout.topControl = this.overTableObjectTypeParent;
        } else {
            Composite cmp = null;
            try {
                cmp = m.getComposite(this);
            }
            catch (Throwable e) {
                SQLExplorerPlugin.error("Error Activating the plugin details ", e);
            }
            this.extComposite = cmp;
            this.sLayout.topControl = cmp != null ? cmp : null;
        }
        this.parent.layout();
    }

    private void createTableObjectTypeComposite() {
        this.overTableObjectTypeParent = new Composite(this.parent, 0);
        this.overTableObjectTypeParent.setLayout((Layout)new FillLayout());
        this.objectCountTextWidget = new Text(this.overTableObjectTypeParent, 2048);
        this.objectCountTextWidget.setEditable(false);
        this.overTableObjectTypeParent.layout();
    }

    private void createTableNodeComposite() {
        this.overParent = new Composite(this.parent, 0);
        this.overParent.setLayout((Layout)new FillLayout());
        this.slm = new StatusLineManager();
        this.detailLog = new StatusLineLogDisplay(this.slm);
        GridLayout layout = new GridLayout();
        GridData gid = new GridData();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.overParent.setLayout((Layout)layout);
        gid.grabExcessVerticalSpace = true;
        gid.grabExcessHorizontalSpace = true;
        gid.verticalAlignment = 4;
        gid.horizontalAlignment = 4;
        Composite _parent = new Composite(this.overParent, 0);
        _parent.setLayout((Layout)new FillLayout());
        _parent.setLayoutData((Object)gid);
        this.tableNodeComposite = new Composite(_parent, 0);
        this.tableNodeComposite.setLayout((Layout)new FillLayout());
        this.tabFolder = new TabFolder(this.tableNodeComposite, 0);
        final TabItem tabItem1 = new TabItem(this.tabFolder, 0);
        tabItem1.setText(Messages.getString("Columns_1"));
        tabItem1.setToolTipText(Messages.getString("Show_Columns_2"));
        this.colDetail = new ColumnsDetail(tabItem1, (Composite)this.tabFolder, this.detailLog);
        final TabItem tabItem2 = new TabItem(this.tabFolder, 0);
        tabItem2.setText(Messages.getString("Indexes_3"));
        tabItem2.setToolTipText(Messages.getString("Show_Indexes_4"));
        this.indDetail = new IndexDetail(tabItem2, (Composite)this.tabFolder, this.detailLog);
        final TabItem tabItem3 = new TabItem(this.tabFolder, 0);
        tabItem3.setText(Messages.getString("Primary_Key_5"));
        tabItem3.setToolTipText(Messages.getString("Show_Primary_Key_Info_6"));
        this.pkDetail = new PKDetail(tabItem3, (Composite)this.tabFolder, this.detailLog);
        final TabItem tabItem4 = new TabItem(this.tabFolder, 0);
        tabItem4.setText(Messages.getString("Foreign_Key_9"));
        tabItem4.setToolTipText(Messages.getString("Show_Foreign_Key_Info_10"));
        this.fkDetail = new FKDetail(tabItem4, (Composite)this.tabFolder, this.detailLog);
        final TabItem tabItem5 = new TabItem(this.tabFolder, 0);
        tabItem5.setText(Messages.getString("Preview_7"));
        tabItem5.setToolTipText(Messages.getString("Show_data_preview_8"));
        this.previewDetail = new PreviewDetail(tabItem5, this.tabFolder, this.detailLog, this.store);
        final TabItem tabItem6 = new TabItem(this.tabFolder, 0);
        tabItem6.setText(Messages.getString("DetailManager.Row_Count_2"));
        tabItem6.setToolTipText(Messages.getString("DetailManager.Display_Row_Count_3"));
        this.rowCountDetail = new RowCountDetail(tabItem6, this.tabFolder, this.detailLog);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DetailManager.this.detailLog.setMessage("");
                if (e.item.equals(tabItem1)) {
                    DetailManager.this.colDetail.activate();
                } else if (e.item.equals(tabItem2)) {
                    DetailManager.this.indDetail.activate();
                } else if (e.item.equals(tabItem3)) {
                    DetailManager.this.pkDetail.activate();
                } else if (e.item.equals(tabItem4)) {
                    DetailManager.this.fkDetail.activate();
                } else if (e.item.equals(tabItem5)) {
                    DetailManager.this.previewDetail.activate();
                } else if (e.item.equals(tabItem6)) {
                    DetailManager.this.rowCountDetail.activate();
                } else if (DetailManager.this.panels != null) {
                    int index = DetailManager.this.tabFolder.indexOf((TabItem)e.item);
                    DetailManager.this.panels[index - 6].activate();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.slm.createControl(this.overParent);
        gid = new GridData();
        gid.horizontalAlignment = 4;
        gid.verticalAlignment = 1;
        this.slm.getControl().setLayoutData((Object)gid);
        this.overParent.layout();
    }

    public StackLayout getSLayout() {
        return this.sLayout;
    }

    public IPreferenceStore getStore() {
        return this.store;
    }

    public void setSLayout(StackLayout sLayout) {
        this.sLayout = sLayout;
    }

    public void clear() {
        this.sLayout.topControl = null;
        this.parent.layout();
    }
}

