/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sqlexplorer.dbviewer;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.sqlexplorer.SqlexplorerImages;
import net.sourceforge.sqlexplorer.dbviewer.model.TableNode;
import net.sourceforge.sqlexplorer.ext.PluginManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DatabaseLabelProvider
extends LabelProvider {
    private Map imageCache = new HashMap(10);
    private Map typeCache = new HashMap(10);
    private ImageDescriptor tableDescriptor = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getTableIcon());
    private ImageDescriptor viewDescriptor = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getViewIcon());
    private ImageDescriptor synDescriptor = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getSynIcon());
    private ImageDescriptor otherDescriptor = ImageDescriptor.createFromURL((URL)SqlexplorerImages.getDatabaseNodeIcon());
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public DatabaseLabelProvider(PluginManager pm) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.sqlexplorer.dbviewer.model.DatabaseNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.typeCache.put(clazz, this.otherDescriptor);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("net.sourceforge.sqlexplorer.dbviewer.model.SchemaNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.typeCache.put(clazz2, this.otherDescriptor);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("net.sourceforge.sqlexplorer.dbviewer.model.CatalogNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.typeCache.put(clazz3, this.otherDescriptor);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("net.sourceforge.sqlexplorer.dbviewer.model.TableObjectTypeNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.typeCache.put(clazz4, this.otherDescriptor);
        Map map = pm.getImageDescriptorsMap();
        if (map != null) {
            this.typeCache.putAll(map);
        }
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = null;
        if (element instanceof TableNode) {
            TableNode tn = (TableNode)element;
            if (tn.isView()) {
                descriptor = this.viewDescriptor;
            } else if (tn.isTable()) {
                descriptor = this.tableDescriptor;
            } else if (tn.isSynonym()) {
                descriptor = this.synDescriptor;
            }
        } else {
            descriptor = (ImageDescriptor)this.typeCache.get(element.getClass());
            if (descriptor == null) {
                descriptor = this.otherDescriptor;
            }
        }
        if (descriptor != null) {
            Image image = (Image)this.imageCache.get(descriptor);
            if (image == null) {
                image = descriptor.createImage();
                this.imageCache.put(descriptor, image);
            }
            return image;
        }
        return null;
    }

    public void dispose() {
        Iterator i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
        this.imageCache.clear();
    }

    public String getText(Object element) {
        return element.toString();
    }
}

